/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.encoder.EncoderBase;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import net.logstash.logback.Logback11Support;
import net.logstash.logback.composite.CompositeJsonFormatter;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.decorate.JsonFactoryDecorator;
import net.logstash.logback.decorate.JsonGeneratorDecorator;
import net.logstash.logback.encoder.SeparatorParser;

public abstract class CompositeJsonEncoder<Event extends DeferredProcessingAware>
extends EncoderBase<Event> {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private boolean logback11ImmediateFlush = true;
    private OutputStream logback11OutputStream;
    private int minBufferSize = 1024;
    private Encoder<Event> prefix;
    private Encoder<Event> suffix;
    private final CompositeJsonFormatter<Event> formatter;
    private String lineSeparator = System.getProperty("line.separator");
    private byte[] lineSeparatorBytes;
    private Charset charset;

    public CompositeJsonEncoder() {
        this.formatter = this.createFormatter();
    }

    protected abstract CompositeJsonFormatter<Event> createFormatter();

    public void init(OutputStream outputStream2) throws IOException {
        Logback11Support.verifyLogback11OrBefore();
        this.logback11OutputStream = outputStream2;
        this.initWrapped(this.prefix, outputStream2);
        this.initWrapped(this.suffix, outputStream2);
    }

    private void initWrapped(Encoder<Event> wrapped, OutputStream outputStream2) throws IOException {
        if (wrapped != null) {
            Logback11Support.init(wrapped, outputStream2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode(Event event) {
        Logback11Support.verifyLogback12OrAfter();
        byte[] prefixBytes = this.doEncodeWrappedToBytes(this.prefix, event);
        byte[] suffixBytes = this.doEncodeWrappedToBytes(this.suffix, event);
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream(this.minBufferSize + (prefixBytes == null ? 0 : prefixBytes.length) + (suffixBytes == null ? 0 : suffixBytes.length) + this.lineSeparatorBytes.length);
        try {
            if (prefixBytes != null) {
                outputStream2.write(prefixBytes);
            }
            this.formatter.writeEventToOutputStream(event, outputStream2);
            if (suffixBytes != null) {
                outputStream2.write(suffixBytes);
            }
            outputStream2.write(this.lineSeparatorBytes);
            byte[] byArray = outputStream2.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            this.addWarn("Error encountered while encoding log event. Event: " + event, e);
            byte[] byArray = EMPTY_BYTES;
            return byArray;
        }
        finally {
            try {
                outputStream2.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void doEncode(Object event) throws IOException {
        this.doEncode((Event)((DeferredProcessingAware)event));
    }

    public void doEncode(Event event) throws IOException {
        Logback11Support.verifyLogback11OrBefore();
        try {
            this.doEncodeWrappedToOutputStream(this.prefix, event);
            this.formatter.writeEventToOutputStream(event, this.logback11OutputStream);
            this.doEncodeWrappedToOutputStream(this.suffix, event);
            this.logback11OutputStream.write(this.lineSeparatorBytes);
            if (this.logback11ImmediateFlush) {
                this.logback11OutputStream.flush();
            }
        }
        catch (IOException e) {
            this.addWarn("Error encountered while encoding log event. OutputStream is now in an unknown state, but will continue to be used for future log events.Event: " + event, e);
        }
    }

    private byte[] doEncodeWrappedToBytes(Encoder<Event> wrapped, Event event) {
        if (wrapped != null) {
            return wrapped.encode(event);
        }
        return EMPTY_BYTES;
    }

    private void doEncodeWrappedToOutputStream(Encoder<Event> wrapped, Event event) throws IOException {
        if (wrapped != null) {
            Logback11Support.doEncode(wrapped, event);
        }
    }

    @Override
    public void start() {
        super.start();
        this.formatter.setContext(this.getContext());
        this.formatter.start();
        this.charset = Charset.forName(this.formatter.getEncoding());
        this.lineSeparatorBytes = this.lineSeparator == null ? EMPTY_BYTES : this.lineSeparator.getBytes(this.charset);
        this.startWrapped(this.prefix);
        this.startWrapped(this.suffix);
        if (Logback11Support.isLogback11OrBefore()) {
            this.addWarn("Logback version is prior to 1.2.0.  Enabling backwards compatible encoding.  Logback 1.2.1 or greater is recommended.");
        }
    }

    private void startWrapped(Encoder<Event> wrapped) {
        if (wrapped instanceof LayoutWrappingEncoder) {
            LayoutWrappingEncoder layoutWrappedEncoder = (LayoutWrappingEncoder)wrapped;
            layoutWrappedEncoder.setCharset(this.charset);
            if (layoutWrappedEncoder.getLayout() instanceof PatternLayoutBase) {
                PatternLayoutBase layout = (PatternLayoutBase)layoutWrappedEncoder.getLayout();
                layout.setPostCompileProcessor(null);
                layout.start();
            }
        }
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.start();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.formatter.stop();
        this.stopWrapped(this.prefix);
        this.stopWrapped(this.suffix);
    }

    private void stopWrapped(Encoder<Event> wrapped) {
        if (wrapped != null && !wrapped.isStarted()) {
            wrapped.stop();
        }
    }

    public void close() throws IOException {
        Logback11Support.verifyLogback11OrBefore();
        this.closeWrapped(this.prefix);
        this.closeWrapped(this.suffix);
    }

    private void closeWrapped(Encoder<Event> wrapped) throws IOException {
        if (wrapped != null && !wrapped.isStarted()) {
            Logback11Support.close(wrapped);
        }
    }

    @Override
    public byte[] headerBytes() {
        return EMPTY_BYTES;
    }

    @Override
    public byte[] footerBytes() {
        return EMPTY_BYTES;
    }

    public JsonProviders<Event> getProviders() {
        return this.formatter.getProviders();
    }

    public void setProviders(JsonProviders<Event> jsonProviders) {
        this.formatter.setProviders(jsonProviders);
    }

    public boolean isImmediateFlush() {
        return this.logback11ImmediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.logback11ImmediateFlush = immediateFlush;
    }

    public JsonFactoryDecorator getJsonFactoryDecorator() {
        return this.formatter.getJsonFactoryDecorator();
    }

    public void setJsonFactoryDecorator(JsonFactoryDecorator jsonFactoryDecorator) {
        this.formatter.setJsonFactoryDecorator(jsonFactoryDecorator);
    }

    public JsonGeneratorDecorator getJsonGeneratorDecorator() {
        return this.formatter.getJsonGeneratorDecorator();
    }

    public String getEncoding() {
        return this.formatter.getEncoding();
    }

    public void setEncoding(String encodingName) {
        this.formatter.setEncoding(encodingName);
    }

    public void setJsonGeneratorDecorator(JsonGeneratorDecorator jsonGeneratorDecorator) {
        this.formatter.setJsonGeneratorDecorator(jsonGeneratorDecorator);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = SeparatorParser.parseSeparator(lineSeparator);
    }

    public int getMinBufferSize() {
        return this.minBufferSize;
    }

    public void setMinBufferSize(int minBufferSize) {
        this.minBufferSize = minBufferSize;
    }

    protected CompositeJsonFormatter<Event> getFormatter() {
        return this.formatter;
    }

    public Encoder<Event> getPrefix() {
        return this.prefix;
    }

    public void setPrefix(Encoder<Event> prefix) {
        this.prefix = prefix;
    }

    public Encoder<Event> getSuffix() {
        return this.suffix;
    }

    public void setSuffix(Encoder<Event> suffix) {
        this.suffix = suffix;
    }
}

