/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.marker;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.logstash.logback.encoder.org.apache.commons.lang.ObjectUtils;
import net.logstash.logback.encoder.org.apache.commons.lang.Validate;
import net.logstash.logback.marker.SingleFieldAppendingMarker;

public class RawJsonAppendingMarker
extends SingleFieldAppendingMarker {
    public static final String MARKER_NAME = "LS_APPEND_RAW";
    private final String rawJson;

    public RawJsonAppendingMarker(String fieldName, String rawJson) {
        super(MARKER_NAME, fieldName);
        Validate.notNull(rawJson, "rawJson must not be null");
        this.rawJson = rawJson;
    }

    public RawJsonAppendingMarker(String fieldName, String rawJson, String messageFormatPattern) {
        super(MARKER_NAME, fieldName, messageFormatPattern);
        Validate.notNull(rawJson, "rawJson must not be null");
        this.rawJson = rawJson;
    }

    @Override
    protected void writeFieldValue(JsonGenerator generator) throws IOException {
        generator.writeRawValue(this.rawJson);
    }

    @Override
    protected Object getFieldValue() {
        return this.rawJson;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RawJsonAppendingMarker)) {
            return false;
        }
        RawJsonAppendingMarker other = (RawJsonAppendingMarker)obj;
        return ObjectUtils.equals(this.rawJson, other.rawJson);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + super.hashCode();
        result = 31 * result + this.rawJson.hashCode();
        return result;
    }
}

