/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import uk.co.flamingpenguin.jewel.cli.ArgumentSpecificationImpl;
import uk.co.flamingpenguin.jewel.cli.Option;
import uk.co.flamingpenguin.jewel.cli.OptionMethodSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionSpecificationImpl
extends ArgumentSpecificationImpl
implements OptionMethodSpecification {
    private static final Logger g_logger = Logger.getLogger(OptionSpecificationImpl.class.getName());
    private final List<String> m_shortNames;
    private final String m_longName;
    private final String m_description;
    private final String m_pattern;
    private final List<String> m_default;
    private final boolean m_helpRequest;

    public OptionSpecificationImpl(Method method, Class<?> klass) {
        super(method, klass);
        Option optionAnnotation = method.getAnnotation(Option.class);
        String[] shortNameSpecification = optionAnnotation.shortName();
        this.m_shortNames = new ArrayList<String>();
        for (int i = 0; i < shortNameSpecification.length; ++i) {
            String shortName = shortNameSpecification[i].trim();
            if (shortName.length() <= 0) continue;
            this.m_shortNames.add(shortNameSpecification[i].substring(0, 1));
        }
        String longNameSpecification = optionAnnotation.longName().trim();
        this.m_longName = this.nullOrBlank(longNameSpecification) ? this.getName() : longNameSpecification;
        this.m_description = optionAnnotation.description().trim();
        this.m_pattern = optionAnnotation.pattern();
        this.m_default = Arrays.asList(optionAnnotation.defaultValue());
        this.m_helpRequest = optionAnnotation.helpRequest();
        g_logger.finer(String.format("Create option specification name:%s, shortName:%s, type:%s (multiValued:%b, hasValue:%b, isOptional:%b, defaultValue:%s)) ", this.getName(), this.getShortNames(), this.getType(), this.isMultiValued(), this.hasValue(), this.isOptional(), this.getDefaultValue()));
    }

    @Override
    public List<String> getShortNames() {
        return this.m_shortNames;
    }

    @Override
    public String getLongName() {
        return this.m_longName;
    }

    public boolean hasCustomPattern() {
        return !this.m_pattern.equals(".*");
    }

    @Override
    public boolean patternMatches(String value) {
        return value.matches(this.m_pattern);
    }

    @Override
    public boolean hasShortName() {
        return this.m_shortNames.size() > 0;
    }

    private boolean nullOrBlank(String string) {
        return string == null || string.equals("");
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public StringBuilder getSummary(StringBuilder result) {
        if (this.isOptional()) {
            result.append("[");
        }
        result.append("--").append(this.getLongName());
        for (String shortName : this.getShortNames()) {
            result.append(" -").append(shortName);
        }
        if (this.hasValue()) {
            if (this.hasCustomPattern()) {
                result.append(" /").append(this.m_pattern).append("/");
            } else {
                result.append(" value");
            }
            if (this.isMultiValued()) {
                result.append("...");
            }
        }
        if (this.isOptional()) {
            result.append("]");
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.getSummary(result);
        if (!this.nullOrBlank(this.getDescription())) {
            result.append(" : ").append(this.getDescription());
        }
        return result.toString();
    }

    @Override
    public List<String> getDefaultValue() {
        return this.m_default;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.m_default.size() > 0;
    }

    @Override
    public boolean isHelpOption() {
        return this.m_helpRequest;
    }
}

