/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.descriptor.refactor;

import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.VisibleForTesting;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

class SecondsDescriptor
implements FieldExpressionVisitor {
    private static final String EVERY = "every";
    protected ResourceBundle bundle;

    SecondsDescriptor(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String describe(FieldExpression fieldExpression) {
        return this.describe(fieldExpression, false);
    }

    protected String describe(FieldExpression fieldExpression, boolean and) {
        Preconditions.checkNotNull(fieldExpression, "CronFieldExpression should not be null!");
        if (fieldExpression instanceof Always) {
            return this.describe(fieldExpression, and);
        }
        if (fieldExpression instanceof And) {
            return this.describe((And)fieldExpression);
        }
        if (fieldExpression instanceof Between) {
            return this.describe(fieldExpression, and);
        }
        if (fieldExpression instanceof Every) {
            return this.describe((Every)fieldExpression, and);
        }
        if (fieldExpression instanceof On) {
            return this.describe((On)fieldExpression, and);
        }
        return "";
    }

    protected String describe(Always always, boolean and) {
        return this.bundle.getString(EVERY);
    }

    protected String describe(And and) {
        ArrayList<FieldExpression> expressions = new ArrayList<FieldExpression>();
        ArrayList<FieldExpression> onExpressions = new ArrayList<FieldExpression>();
        for (FieldExpression fieldExpression : and.getExpressions()) {
            if (fieldExpression instanceof On) {
                onExpressions.add(fieldExpression);
                continue;
            }
            expressions.add(fieldExpression);
        }
        StringBuilder builder = new StringBuilder();
        if (!onExpressions.isEmpty()) {
            builder.append(this.bundle.getString("at"));
            this.createAndDescription(builder, onExpressions);
        }
        if (!expressions.isEmpty()) {
            this.createAndDescription(builder, expressions);
        }
        return builder.toString();
    }

    protected String describe(Between between, boolean and) {
        return MessageFormat.format(this.bundle.getString("between_x_and_y"), this.nominalValue(between.getFrom()), this.nominalValue(between.getTo())) + " ";
    }

    protected String describe(Every every, boolean and) {
        return null;
    }

    protected String describe(On on, boolean and) {
        if (and) {
            return this.nominalValue(on.getTime());
        }
        return String.format("%s %s ", this.bundle.getString("at"), this.nominalValue(on.getTime())) + "%s";
    }

    protected String nominalValue(FieldValue<?> fieldValue) {
        Preconditions.checkNotNull(fieldValue, "FieldValue must not be null");
        if (fieldValue instanceof IntegerFieldValue) {
            return "" + ((IntegerFieldValue)fieldValue).getValue();
        }
        return fieldValue.toString();
    }

    @VisibleForTesting
    StringBuilder createAndDescription(StringBuilder builder, List<FieldExpression> expressions) {
        if (expressions.size() - 2 >= 0) {
            for (int j = 0; j < expressions.size() - 2; ++j) {
                builder.append(String.format(" %s, ", this.describe(expressions.get(j), true)));
            }
            builder.append(String.format(" %s ", this.describe(expressions.get(expressions.size() - 2), true)));
        }
        builder.append(String.format(" %s ", this.bundle.getString("and")));
        builder.append(this.describe(expressions.get(expressions.size() - 1), true));
        return builder;
    }

    @Override
    public FieldExpression visit(FieldExpression expression) {
        return null;
    }

    @Override
    public Always visit(Always always) {
        return null;
    }

    @Override
    public And visit(And and) {
        return null;
    }

    @Override
    public Between visit(Between between) {
        return null;
    }

    @Override
    public Every visit(Every every) {
        if (every.getPeriod().getValue() > 1) {
            String description = String.format("%s %s ", this.bundle.getString(EVERY), this.nominalValue(every.getPeriod())) + " replace_plural ";
        } else {
            String description = this.bundle.getString(EVERY) + " %s ";
        }
        return every;
    }

    @Override
    public On visit(On on) {
        return null;
    }

    @Override
    public QuestionMark visit(QuestionMark questionMark) {
        return null;
    }
}

