/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.connection;

import com.getsentry.raven.connection.AbstractConnection;
import com.getsentry.raven.connection.ConnectionException;
import com.getsentry.raven.event.Event;
import com.getsentry.raven.marshaller.Marshaller;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class OutputStreamConnection
extends AbstractConnection {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final OutputStream outputStream;
    private Marshaller marshaller;

    public OutputStreamConnection(OutputStream outputStream2) {
        super(null, null);
        this.outputStream = outputStream2;
    }

    @Override
    protected synchronized void doSend(Event event) throws ConnectionException {
        try {
            this.outputStream.write("Raven event:\n".getBytes(UTF_8));
            this.marshaller.marshall(event, this.outputStream);
            this.outputStream.write("\n".getBytes(UTF_8));
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new ConnectionException("Couldn't sent the event properly", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

