/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import com.getsentry.raven.Raven;
import com.getsentry.raven.RavenFactory;
import com.getsentry.raven.config.Lookup;
import com.getsentry.raven.dsn.Dsn;
import com.getsentry.raven.dsn.InvalidDsnException;
import com.getsentry.raven.environment.RavenEnvironment;
import com.getsentry.raven.event.Event;
import com.getsentry.raven.event.EventBuilder;
import com.getsentry.raven.event.interfaces.ExceptionInterface;
import com.getsentry.raven.event.interfaces.MessageInterface;
import com.getsentry.raven.event.interfaces.SentryException;
import com.getsentry.raven.event.interfaces.StackTraceInterface;
import com.getsentry.raven.util.Util;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SentryAppender
extends AppenderBase<ILoggingEvent> {
    public static final String LOGBACK_MARKER = "logback-Marker";
    public static final String THREAD_NAME = "Raven-Threadname";
    protected volatile Raven raven;
    protected String dsn;
    protected String ravenFactory;
    protected String release;
    protected String environment;
    protected String serverName;
    protected Level minLevel;
    protected Map<String, String> tags = Collections.emptyMap();
    protected Set<String> extraTags = Collections.emptySet();

    public SentryAppender() {
        this.setRavenFactory(Lookup.lookup("ravenFactory"));
        this.setRelease(Lookup.lookup("release"));
        this.setEnvironment(Lookup.lookup("environment"));
        this.setServerName(Lookup.lookup("serverName"));
        this.setTags(Lookup.lookup("tags"));
        this.setExtraTags(Lookup.lookup("extraTags"));
        this.addFilter(new DropRavenFilter());
    }

    public SentryAppender(Raven raven) {
        this();
        this.raven = raven;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> arguments = new ArrayList<String>(parameters.length);
        for (Object argument : parameters) {
            arguments.add(argument != null ? argument.toString() : null);
        }
        return arguments;
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isGreaterOrEqual(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isGreaterOrEqual(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isGreaterOrEqual(Level.INFO)) {
            return Event.Level.INFO;
        }
        if (level.isGreaterOrEqual(Level.ALL)) {
            return Event.Level.DEBUG;
        }
        return null;
    }

    @Override
    protected void append(ILoggingEvent iLoggingEvent) {
        if (RavenEnvironment.isManagingThread()) {
            return;
        }
        RavenEnvironment.startManagingThread();
        try {
            if (this.minLevel != null && !iLoggingEvent.getLevel().isGreaterOrEqual(this.minLevel)) {
                return;
            }
            if (this.raven == null) {
                this.initRaven();
            }
            Event event = this.buildEvent(iLoggingEvent);
            this.raven.sendEvent(event);
        }
        catch (Exception e) {
            this.addError("An exception occurred while creating a new event in Raven", e);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    protected synchronized void initRaven() {
        try {
            if (this.dsn == null) {
                this.dsn = Dsn.dsnLookup();
            }
            this.raven = RavenFactory.ravenInstance(new Dsn(this.dsn), this.ravenFactory);
        }
        catch (InvalidDsnException e) {
            this.addError("An exception occurred during the retrieval of the DSN for Raven", e);
        }
        catch (Exception e) {
            this.addError("An exception occurred during the creation of a Raven instance", e);
        }
    }

    protected Event buildEvent(ILoggingEvent iLoggingEvent) {
        EventBuilder eventBuilder = new EventBuilder().withSdkName("raven-java:logback").withTimestamp(new Date(iLoggingEvent.getTimeStamp())).withMessage(iLoggingEvent.getFormattedMessage()).withLogger(iLoggingEvent.getLoggerName()).withLevel(SentryAppender.formatLevel(iLoggingEvent.getLevel())).withExtra(THREAD_NAME, iLoggingEvent.getThreadName());
        if (!Util.isNullOrEmpty(this.serverName)) {
            eventBuilder.withServerName(this.serverName.trim());
        }
        if (!Util.isNullOrEmpty(this.release)) {
            eventBuilder.withRelease(this.release.trim());
        }
        if (!Util.isNullOrEmpty(this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        if (iLoggingEvent.getArgumentArray() != null) {
            eventBuilder.withSentryInterface(new MessageInterface(iLoggingEvent.getMessage(), SentryAppender.formatMessageParameters(iLoggingEvent.getArgumentArray()), iLoggingEvent.getFormattedMessage()));
        }
        if (iLoggingEvent.getThrowableProxy() != null) {
            eventBuilder.withSentryInterface(new ExceptionInterface(this.extractExceptionQueue(iLoggingEvent)));
        } else if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.withSentryInterface(new StackTraceInterface(iLoggingEvent.getCallerData()));
        }
        if (iLoggingEvent.getCallerData().length > 0) {
            eventBuilder.withCulprit(iLoggingEvent.getCallerData()[0]);
        } else {
            eventBuilder.withCulprit(iLoggingEvent.getLoggerName());
        }
        for (Map.Entry<String, String> contextEntry : iLoggingEvent.getLoggerContextVO().getPropertyMap().entrySet()) {
            eventBuilder.withExtra(contextEntry.getKey(), contextEntry.getValue());
        }
        for (Map.Entry<String, String> mdcEntry : iLoggingEvent.getMDCPropertyMap().entrySet()) {
            if (this.extraTags.contains(mdcEntry.getKey())) {
                eventBuilder.withTag(mdcEntry.getKey(), mdcEntry.getValue());
                continue;
            }
            eventBuilder.withExtra(mdcEntry.getKey(), mdcEntry.getValue());
        }
        if (iLoggingEvent.getMarker() != null) {
            eventBuilder.withTag(LOGBACK_MARKER, iLoggingEvent.getMarker().getName());
        }
        for (Map.Entry<String, String> tagEntry : this.tags.entrySet()) {
            eventBuilder.withTag(tagEntry.getKey(), tagEntry.getValue());
        }
        this.raven.runBuilderHelpers(eventBuilder);
        return eventBuilder.build();
    }

    protected Deque<SentryException> extractExceptionQueue(ILoggingEvent iLoggingEvent) {
        ArrayDeque<SentryException> exceptions = new ArrayDeque<SentryException>();
        HashSet<IThrowableProxy> circularityDetector = new HashSet<IThrowableProxy>();
        StackTraceElement[] enclosingStackTrace = new StackTraceElement[]{};
        for (IThrowableProxy throwableProxy = iLoggingEvent.getThrowableProxy(); throwableProxy != null; throwableProxy = throwableProxy.getCause()) {
            if (!circularityDetector.add(throwableProxy)) {
                this.addWarn("Exiting a circular exception!");
                break;
            }
            StackTraceElement[] stackTraceElements = this.toStackTraceElements(throwableProxy);
            StackTraceInterface stackTrace = new StackTraceInterface(stackTraceElements, enclosingStackTrace);
            exceptions.push(this.createSentryExceptionFrom(throwableProxy, stackTrace));
            enclosingStackTrace = stackTraceElements;
        }
        return exceptions;
    }

    protected SentryException createSentryExceptionFrom(IThrowableProxy throwableProxy, StackTraceInterface stackTrace) {
        String exceptionMessage = throwableProxy.getMessage();
        String[] packageNameSimpleName = this.extractPackageSimpleClassName(throwableProxy.getClassName());
        String exceptionPackageName = packageNameSimpleName[0];
        String exceptionClassName = packageNameSimpleName[1];
        return new SentryException(exceptionMessage, exceptionClassName, exceptionPackageName, stackTrace);
    }

    protected String[] extractPackageSimpleClassName(String canonicalClassName) {
        String[] packageNameSimpleName = new String[2];
        try {
            Class<?> exceptionClass = Class.forName(canonicalClassName);
            Package exceptionPackage = exceptionClass.getPackage();
            packageNameSimpleName[0] = exceptionPackage != null ? exceptionPackage.getName() : "(default)";
            packageNameSimpleName[1] = exceptionClass.getSimpleName();
        }
        catch (ClassNotFoundException e) {
            int lastDot = canonicalClassName.lastIndexOf(46);
            if (lastDot != -1) {
                packageNameSimpleName[0] = canonicalClassName.substring(0, lastDot);
                packageNameSimpleName[1] = canonicalClassName.substring(lastDot);
            }
            packageNameSimpleName[0] = "(default)";
            packageNameSimpleName[1] = canonicalClassName;
        }
        return packageNameSimpleName;
    }

    protected StackTraceElement[] toStackTraceElements(IThrowableProxy throwableProxy) {
        StackTraceElementProxy[] stackTraceElementProxies = throwableProxy.getStackTraceElementProxyArray();
        StackTraceElement[] stackTraceElements = new StackTraceElement[stackTraceElementProxies.length];
        int stackTraceElementsLength = stackTraceElementProxies.length;
        for (int i = 0; i < stackTraceElementsLength; ++i) {
            stackTraceElements[i] = stackTraceElementProxies[i].getStackTraceElement();
        }
        return stackTraceElements;
    }

    public void setDsn(String dsn) {
        this.dsn = dsn;
    }

    public void setRavenFactory(String ravenFactory) {
        this.ravenFactory = ravenFactory;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setMinLevel(String minLevel) {
        this.minLevel = minLevel != null ? Level.toLevel(minLevel) : null;
    }

    public void setTags(String tags) {
        this.tags = Util.parseTags(tags);
    }

    public void setExtraTags(String extraTags) {
        this.extraTags = Util.parseExtraTags(extraTags);
    }

    @Override
    public void stop() {
        RavenEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            if (this.raven != null) {
                this.raven.closeConnection();
            }
        }
        catch (Exception e) {
            this.addError("An exception occurred while closing the Raven connection", e);
        }
        finally {
            RavenEnvironment.stopManagingThread();
        }
    }

    private class DropRavenFilter
    extends Filter<ILoggingEvent> {
        private DropRavenFilter() {
        }

        @Override
        public FilterReply decide(ILoggingEvent event) {
            String loggerName = event.getLoggerName();
            if (loggerName != null && loggerName.startsWith("com.getsentry.raven")) {
                return FilterReply.DENY;
            }
            return FilterReply.NEUTRAL;
        }
    }
}

