/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.oauth2;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.oauth2.Oauth2Request;
import com.google.api.services.oauth2.Oauth2RequestInitializer;
import com.google.api.services.oauth2.model.Jwk;
import com.google.api.services.oauth2.model.Userinfoplus;
import java.io.IOException;

public class Oauth2
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch/oauth2/v2";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/";

    public Oauth2(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Oauth2(Builder builder) {
        super(builder);
    }

    @Override
    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Userinfo userinfo() {
        return new Userinfo();
    }

    public GetCertForOpenIdConnect getCertForOpenIdConnect() throws IOException {
        GetCertForOpenIdConnect result = new GetCertForOpenIdConnect();
        this.initialize(result);
        return result;
    }

    public Tokeninfo tokeninfo() throws IOException {
        Tokeninfo result = new Tokeninfo();
        this.initialize(result);
        return result;
    }

    static {
        Preconditions.checkState(GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15, "You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.30.8 of the Google OAuth2 API library.", GoogleUtils.VERSION);
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://www.googleapis.com/", Oauth2.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Oauth2.DEFAULT_BATCH_PATH);
        }

        @Override
        public Oauth2 build() {
            return new Oauth2(this);
        }

        @Override
        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        @Override
        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        @Override
        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        @Override
        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        @Override
        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        @Override
        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        @Override
        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        @Override
        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setOauth2RequestInitializer(Oauth2RequestInitializer oauth2RequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(oauth2RequestInitializer);
        }

        @Override
        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Tokeninfo
    extends Oauth2Request<com.google.api.services.oauth2.model.Tokeninfo> {
        private static final String REST_PATH = "oauth2/v2/tokeninfo";
        @Key(value="access_token")
        private String accessToken;
        @Key(value="id_token")
        private String idToken;
        @Key(value="token_handle")
        private String tokenHandle;

        protected Tokeninfo() {
            super(Oauth2.this, "POST", REST_PATH, (Object)null, com.google.api.services.oauth2.model.Tokeninfo.class);
        }

        public Tokeninfo setAlt(String alt) {
            return (Tokeninfo)super.setAlt(alt);
        }

        public Tokeninfo setFields(String fields) {
            return (Tokeninfo)super.setFields(fields);
        }

        public Tokeninfo setKey(String key) {
            return (Tokeninfo)super.setKey(key);
        }

        public Tokeninfo setOauthToken(String oauthToken) {
            return (Tokeninfo)super.setOauthToken(oauthToken);
        }

        public Tokeninfo setPrettyPrint(Boolean prettyPrint) {
            return (Tokeninfo)super.setPrettyPrint(prettyPrint);
        }

        public Tokeninfo setQuotaUser(String quotaUser) {
            return (Tokeninfo)super.setQuotaUser(quotaUser);
        }

        public Tokeninfo setUserIp(String userIp) {
            return (Tokeninfo)super.setUserIp(userIp);
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Tokeninfo setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public Tokeninfo setIdToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public String getTokenHandle() {
            return this.tokenHandle;
        }

        public Tokeninfo setTokenHandle(String tokenHandle) {
            this.tokenHandle = tokenHandle;
            return this;
        }

        @Override
        public Tokeninfo set(String parameterName, Object value) {
            return (Tokeninfo)super.set(parameterName, value);
        }
    }

    public class GetCertForOpenIdConnect
    extends Oauth2Request<Jwk> {
        private static final String REST_PATH = "oauth2/v2/certs";

        protected GetCertForOpenIdConnect() {
            super(Oauth2.this, "GET", REST_PATH, (Object)null, Jwk.class);
        }

        @Override
        public HttpResponse executeUsingHead() throws IOException {
            return super.executeUsingHead();
        }

        @Override
        public HttpRequest buildHttpRequestUsingHead() throws IOException {
            return super.buildHttpRequestUsingHead();
        }

        public GetCertForOpenIdConnect setAlt(String alt) {
            return (GetCertForOpenIdConnect)super.setAlt(alt);
        }

        public GetCertForOpenIdConnect setFields(String fields) {
            return (GetCertForOpenIdConnect)super.setFields(fields);
        }

        public GetCertForOpenIdConnect setKey(String key) {
            return (GetCertForOpenIdConnect)super.setKey(key);
        }

        public GetCertForOpenIdConnect setOauthToken(String oauthToken) {
            return (GetCertForOpenIdConnect)super.setOauthToken(oauthToken);
        }

        public GetCertForOpenIdConnect setPrettyPrint(Boolean prettyPrint) {
            return (GetCertForOpenIdConnect)super.setPrettyPrint(prettyPrint);
        }

        public GetCertForOpenIdConnect setQuotaUser(String quotaUser) {
            return (GetCertForOpenIdConnect)super.setQuotaUser(quotaUser);
        }

        public GetCertForOpenIdConnect setUserIp(String userIp) {
            return (GetCertForOpenIdConnect)super.setUserIp(userIp);
        }

        @Override
        public GetCertForOpenIdConnect set(String parameterName, Object value) {
            return (GetCertForOpenIdConnect)super.set(parameterName, value);
        }
    }

    public class Userinfo {
        public Get get() throws IOException {
            Get result = new Get();
            Oauth2.this.initialize(result);
            return result;
        }

        public V2 v2() {
            return new V2();
        }

        public class V2 {
            public Me me() {
                return new Me();
            }

            public class Me {
                public Get get() throws IOException {
                    Get result = new Get();
                    Oauth2.this.initialize(result);
                    return result;
                }

                public class Get
                extends Oauth2Request<Userinfoplus> {
                    private static final String REST_PATH = "userinfo/v2/me";

                    protected Get() {
                        super(Oauth2.this, "GET", REST_PATH, (Object)null, Userinfoplus.class);
                    }

                    @Override
                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    @Override
                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUserIp(String userIp) {
                        return (Get)super.setUserIp(userIp);
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }
            }
        }

        public class Get
        extends Oauth2Request<Userinfoplus> {
            private static final String REST_PATH = "oauth2/v2/userinfo";

            protected Get() {
                super(Oauth2.this, "GET", REST_PATH, (Object)null, Userinfoplus.class);
            }

            @Override
            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            @Override
            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUserIp(String userIp) {
                return (Get)super.setUserIp(userIp);
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

