/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.logging;

import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;

public class LoggingSupport {
    protected static final AtomicLong rid = new AtomicLong();

    public static void debug(Logger logger, String type, int version, Ident ident, Object ... args) {
        logger.debug(LoggingSupport.buildLogLine(type, version, ident, args));
    }

    public static void info(Logger logger, String type, int version, Ident ident, Object ... args) {
        logger.info(LoggingSupport.buildLogLine(type, version, ident, args));
    }

    public static void warn(Logger logger, String type, int version, Ident ident, Object ... args) {
        logger.warn(LoggingSupport.buildLogLine(type, version, ident, args));
    }

    public static void error(Logger logger, String type, int version, Ident ident, Object ... args) {
        logger.error(LoggingSupport.buildLogLine(type, version, ident, args));
    }

    protected static String buildLogLine(String type, int version, Ident ident, Object ... args) {
        StringBuilder line = new StringBuilder();
        line.append(rid.getAndIncrement()).append(' ');
        if (ident == null) {
            line.append(Ident.EMPTY_IDENT);
        } else {
            line.append(ident);
        }
        line.append(' ');
        line.append(type).append('\t').append(version);
        for (Object arg : args) {
            line.append('\t');
            LoggingSupport.appendEscaped(arg, line);
        }
        return line.toString();
    }

    protected static void appendEscaped(Object o, StringBuilder out) {
        if (o == null) {
            return;
        }
        String s2 = o.toString();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\t' || c == '\n') {
                out.append(' ');
                continue;
            }
            out.append(c);
        }
    }

    public static class Ident {
        public static final Ident EMPTY_IDENT = new Ident(0, new Object[0]);
        private final String ident;

        public Ident(int version, Object ... identData) {
            StringBuilder buf = new StringBuilder();
            if (version != 0) {
                buf.append(version).append(':');
            }
            buf.append('[');
            boolean first = true;
            for (Object part : identData) {
                if (!first) {
                    buf.append('\t');
                } else {
                    first = false;
                }
                LoggingSupport.appendEscaped(part, buf);
            }
            buf.append(']');
            this.ident = buf.toString();
        }

        public String toString() {
            return this.ident;
        }
    }
}

