/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.logging.logback;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.spotify.logging.LoggingConfigurator;
import com.spotify.logging.logback.MillisecondPrecisionSyslogAppender;
import java.lang.management.ManagementFactory;

public class SpotifyInternalAppender
extends MillisecondPrecisionSyslogAppender {
    private String serviceName;
    private boolean portConfigured = false;
    private LoggingConfigurator.ReplaceNewLines replaceNewLines = LoggingConfigurator.ReplaceNewLines.OFF;

    @Override
    public void start() {
        Preconditions.checkState(this.serviceName != null, "serviceName must be configured");
        this.setFacility("LOCAL0");
        String serviceAndPid = String.format("%s[%s]", this.serviceName, SpotifyInternalAppender.getMyPid());
        this.setSuffixPattern(serviceAndPid + ": " + LoggingConfigurator.ReplaceNewLines.getMsgPattern(this.replaceNewLines));
        this.setStackTracePattern(serviceAndPid + ": " + '\t');
        if (this.getSyslogHost() == null) {
            this.setSyslogHost(System.getenv("SPOTIFY_SYSLOG_HOST"));
        }
        this.checkSetPort(System.getenv("SPOTIFY_SYSLOG_PORT"));
        super.start();
    }

    private void checkSetPort(String environmentValue) {
        if (environmentValue == null || this.portConfigured) {
            return;
        }
        try {
            this.setPort(Integer.parseInt(environmentValue));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse value for \"SPOTIFY_SYSLOG_PORT\" (" + environmentValue + ") as an int", e);
        }
    }

    @Override
    public void setPort(int port) {
        this.portConfigured = true;
        super.setPort(port);
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setReplaceNewLines(LoggingConfigurator.ReplaceNewLines replaceNewLines) {
        this.replaceNewLines = replaceNewLines;
    }

    @VisibleForTesting
    static String getMyPid() {
        String pid = "0";
        try {
            String nameStr = ManagementFactory.getRuntimeMXBean().getName();
            pid = nameStr.split("@")[0];
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return pid;
    }
}

