/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.spotify.styx.api.RunStateDataPayload;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.state.StateData;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class RunStateDataBuilder {
    private WorkflowInstance workflowInstance;
    private String state;
    private StateData stateData;
    private Optional<Long> initialTimestamp;
    private Optional<Long> latestTimestamp;

    public RunStateDataBuilder() {
        this.initialTimestamp = Optional.empty();
        this.latestTimestamp = Optional.empty();
    }

    private RunStateDataBuilder(RunStateDataPayload.RunStateData v) {
        this.workflowInstance = v.workflowInstance();
        this.state = v.state();
        this.stateData = v.stateData();
        this.initialTimestamp = v.initialTimestamp();
        this.latestTimestamp = v.latestTimestamp();
    }

    private RunStateDataBuilder(RunStateDataBuilder v) {
        this.workflowInstance = v.workflowInstance;
        this.state = v.state;
        this.stateData = v.stateData;
        this.initialTimestamp = v.initialTimestamp;
        this.latestTimestamp = v.latestTimestamp;
    }

    public WorkflowInstance workflowInstance() {
        return this.workflowInstance;
    }

    public RunStateDataBuilder workflowInstance(WorkflowInstance workflowInstance) {
        if (workflowInstance == null) {
            throw new NullPointerException("workflowInstance");
        }
        this.workflowInstance = workflowInstance;
        return this;
    }

    public String state() {
        return this.state;
    }

    public RunStateDataBuilder state(String state) {
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.state = state;
        return this;
    }

    public StateData stateData() {
        return this.stateData;
    }

    public RunStateDataBuilder stateData(StateData stateData) {
        if (stateData == null) {
            throw new NullPointerException("stateData");
        }
        this.stateData = stateData;
        return this;
    }

    public Optional<Long> initialTimestamp() {
        return this.initialTimestamp;
    }

    public RunStateDataBuilder initialTimestamp(Long initialTimestamp) {
        return this.initialTimestamp(Optional.ofNullable(initialTimestamp));
    }

    public RunStateDataBuilder initialTimestamp(Optional<? extends Long> initialTimestamp) {
        if (initialTimestamp == null) {
            throw new NullPointerException("initialTimestamp");
        }
        this.initialTimestamp = initialTimestamp;
        return this;
    }

    public Optional<Long> latestTimestamp() {
        return this.latestTimestamp;
    }

    public RunStateDataBuilder latestTimestamp(Long latestTimestamp) {
        return this.latestTimestamp(Optional.ofNullable(latestTimestamp));
    }

    public RunStateDataBuilder latestTimestamp(Optional<? extends Long> latestTimestamp) {
        if (latestTimestamp == null) {
            throw new NullPointerException("latestTimestamp");
        }
        this.latestTimestamp = latestTimestamp;
        return this;
    }

    public RunStateDataBuilder builder() {
        return new RunStateDataBuilder(this);
    }

    public RunStateDataPayload.RunStateData build() {
        return new Value(this.workflowInstance, this.state, this.stateData, this.initialTimestamp, this.latestTimestamp);
    }

    public static RunStateDataBuilder from(RunStateDataPayload.RunStateData v) {
        return new RunStateDataBuilder(v);
    }

    public static RunStateDataBuilder from(RunStateDataBuilder v) {
        return new RunStateDataBuilder(v);
    }

    private static final class Value
    implements RunStateDataPayload.RunStateData {
        private final WorkflowInstance workflowInstance;
        private final String state;
        private final StateData stateData;
        private final Optional<Long> initialTimestamp;
        private final Optional<Long> latestTimestamp;

        private Value(@AutoMatter.Field(value="workflowInstance") WorkflowInstance workflowInstance, @AutoMatter.Field(value="state") String state, @AutoMatter.Field(value="stateData") StateData stateData, @AutoMatter.Field(value="initialTimestamp") Optional<Long> initialTimestamp, @AutoMatter.Field(value="latestTimestamp") Optional<Long> latestTimestamp) {
            if (workflowInstance == null) {
                throw new NullPointerException("workflowInstance");
            }
            if (state == null) {
                throw new NullPointerException("state");
            }
            if (stateData == null) {
                throw new NullPointerException("stateData");
            }
            if (initialTimestamp == null) {
                throw new NullPointerException("initialTimestamp");
            }
            if (latestTimestamp == null) {
                throw new NullPointerException("latestTimestamp");
            }
            this.workflowInstance = workflowInstance;
            this.state = state;
            this.stateData = stateData;
            this.initialTimestamp = initialTimestamp;
            this.latestTimestamp = latestTimestamp;
        }

        @Override
        @AutoMatter.Field
        public WorkflowInstance workflowInstance() {
            return this.workflowInstance;
        }

        @Override
        @AutoMatter.Field
        public String state() {
            return this.state;
        }

        @Override
        @AutoMatter.Field
        public StateData stateData() {
            return this.stateData;
        }

        @Override
        @AutoMatter.Field
        public Optional<Long> initialTimestamp() {
            return this.initialTimestamp;
        }

        @Override
        @AutoMatter.Field
        public Optional<Long> latestTimestamp() {
            return this.latestTimestamp;
        }

        @Override
        public RunStateDataBuilder builder() {
            return new RunStateDataBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RunStateDataPayload.RunStateData)) {
                return false;
            }
            RunStateDataPayload.RunStateData that = (RunStateDataPayload.RunStateData)o;
            if (this.workflowInstance != null ? !this.workflowInstance.equals(that.workflowInstance()) : that.workflowInstance() != null) {
                return false;
            }
            if (this.state != null ? !this.state.equals(that.state()) : that.state() != null) {
                return false;
            }
            if (this.stateData != null ? !this.stateData.equals(that.stateData()) : that.stateData() != null) {
                return false;
            }
            if (this.initialTimestamp != null ? !this.initialTimestamp.equals(that.initialTimestamp()) : that.initialTimestamp() != null) {
                return false;
            }
            return !(this.latestTimestamp != null ? !this.latestTimestamp.equals(that.latestTimestamp()) : that.latestTimestamp() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.workflowInstance != null ? this.workflowInstance.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.stateData != null ? this.stateData.hashCode() : 0);
            result = 31 * result + (this.initialTimestamp != null ? this.initialTimestamp.hashCode() : 0);
            result = 31 * result + (this.latestTimestamp != null ? this.latestTimestamp.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "RunStateDataPayload.RunStateData{workflowInstance=" + this.workflowInstance + ", state=" + this.state + ", stateData=" + this.stateData + ", initialTimestamp=" + this.initialTimestamp + ", latestTimestamp=" + this.latestTimestamp + "}";
        }
    }
}

