/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.FlyteExecConf;
import com.spotify.styx.model.FlyteIdentifier;
import io.norberg.automatter.AutoMatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class FlyteExecConfBuilder {
    private FlyteIdentifier referenceId;
    private Map<String, String> inputFields;

    public FlyteExecConfBuilder() {
    }

    private FlyteExecConfBuilder(FlyteExecConf v) {
        this.referenceId = v.referenceId();
        Map<String, String> _inputFields = v.inputFields();
        this.inputFields = _inputFields == null ? null : new HashMap<String, String>(_inputFields);
    }

    private FlyteExecConfBuilder(FlyteExecConfBuilder v) {
        this.referenceId = v.referenceId;
        this.inputFields = v.inputFields == null ? null : new HashMap<String, String>(v.inputFields);
    }

    public FlyteIdentifier referenceId() {
        return this.referenceId;
    }

    public FlyteExecConfBuilder referenceId(FlyteIdentifier referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId");
        }
        this.referenceId = referenceId;
        return this;
    }

    public Map<String, String> inputFields() {
        if (this.inputFields == null) {
            this.inputFields = new HashMap<String, String>();
        }
        return this.inputFields;
    }

    public FlyteExecConfBuilder inputFields(Map<? extends String, ? extends String> inputFields) {
        if (inputFields == null) {
            throw new NullPointerException("inputFields");
        }
        for (Map.Entry<? extends String, ? extends String> entry : inputFields.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("inputFields: null key");
            }
            if (entry.getValue() != null) continue;
            throw new NullPointerException("inputFields: null value");
        }
        this.inputFields = new HashMap<String, String>(inputFields);
        return this;
    }

    public FlyteExecConfBuilder inputFields(String k1, String v1) {
        if (k1 == null) {
            throw new NullPointerException("inputFields: k1");
        }
        if (v1 == null) {
            throw new NullPointerException("inputFields: v1");
        }
        this.inputFields = new HashMap<String, String>();
        this.inputFields.put(k1, v1);
        return this;
    }

    public FlyteExecConfBuilder inputFields(String k1, String v1, String k2, String v2) {
        this.inputFields(k1, v1);
        if (k2 == null) {
            throw new NullPointerException("inputFields: k2");
        }
        if (v2 == null) {
            throw new NullPointerException("inputFields: v2");
        }
        this.inputFields.put(k2, v2);
        return this;
    }

    public FlyteExecConfBuilder inputFields(String k1, String v1, String k2, String v2, String k3, String v3) {
        this.inputFields(k1, v1, k2, v2);
        if (k3 == null) {
            throw new NullPointerException("inputFields: k3");
        }
        if (v3 == null) {
            throw new NullPointerException("inputFields: v3");
        }
        this.inputFields.put(k3, v3);
        return this;
    }

    public FlyteExecConfBuilder inputFields(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4) {
        this.inputFields(k1, v1, k2, v2, k3, v3);
        if (k4 == null) {
            throw new NullPointerException("inputFields: k4");
        }
        if (v4 == null) {
            throw new NullPointerException("inputFields: v4");
        }
        this.inputFields.put(k4, v4);
        return this;
    }

    public FlyteExecConfBuilder inputFields(String k1, String v1, String k2, String v2, String k3, String v3, String k4, String v4, String k5, String v5) {
        this.inputFields(k1, v1, k2, v2, k3, v3, k4, v4);
        if (k5 == null) {
            throw new NullPointerException("inputFields: k5");
        }
        if (v5 == null) {
            throw new NullPointerException("inputFields: v5");
        }
        this.inputFields.put(k5, v5);
        return this;
    }

    public FlyteExecConfBuilder putInputField(String key, String value) {
        if (key == null) {
            throw new NullPointerException("inputField: key");
        }
        if (value == null) {
            throw new NullPointerException("inputField: value");
        }
        if (this.inputFields == null) {
            this.inputFields = new HashMap<String, String>();
        }
        this.inputFields.put(key, value);
        return this;
    }

    public FlyteExecConf build() {
        Map<String, String> _inputFields = this.inputFields != null ? Collections.unmodifiableMap(new HashMap<String, String>(this.inputFields)) : Collections.emptyMap();
        return new Value(this.referenceId, _inputFields);
    }

    public static FlyteExecConfBuilder from(FlyteExecConf v) {
        return new FlyteExecConfBuilder(v);
    }

    public static FlyteExecConfBuilder from(FlyteExecConfBuilder v) {
        return new FlyteExecConfBuilder(v);
    }

    private static final class Value
    implements FlyteExecConf {
        private final FlyteIdentifier referenceId;
        private final Map<String, String> inputFields;

        private Value(@AutoMatter.Field(value="referenceId") FlyteIdentifier referenceId, @AutoMatter.Field(value="inputFields") Map<String, String> inputFields) {
            if (referenceId == null) {
                throw new NullPointerException("referenceId");
            }
            this.referenceId = referenceId;
            this.inputFields = inputFields != null ? inputFields : Collections.emptyMap();
        }

        @Override
        @AutoMatter.Field
        public FlyteIdentifier referenceId() {
            return this.referenceId;
        }

        @Override
        @AutoMatter.Field
        public Map<String, String> inputFields() {
            return this.inputFields;
        }

        @Override
        public FlyteExecConfBuilder builder() {
            return new FlyteExecConfBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FlyteExecConf)) {
                return false;
            }
            FlyteExecConf that = (FlyteExecConf)o;
            if (this.referenceId != null ? !this.referenceId.equals(that.referenceId()) : that.referenceId() != null) {
                return false;
            }
            return !(this.inputFields != null ? !this.inputFields.equals(that.inputFields()) : that.inputFields() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.referenceId != null ? this.referenceId.hashCode() : 0);
            result = 31 * result + (this.inputFields != null ? this.inputFields.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "FlyteExecConf{referenceId=" + this.referenceId + ", inputFields=" + this.inputFields + "}";
        }
    }
}

