/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.state;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.spotify.styx.state.MessageBuilder;
import io.norberg.automatter.AutoMatter;

@AutoMatter
public interface Message {
    public MessageLevel level();

    public String line();

    public static Message create(MessageLevel level, String line) {
        return new MessageBuilder().level(level).line(line).build();
    }

    public static Message info(String line) {
        return Message.create(MessageLevel.INFO, line);
    }

    public static Message warning(String line) {
        return Message.create(MessageLevel.WARNING, line);
    }

    public static Message error(String line) {
        return Message.create(MessageLevel.ERROR, line);
    }

    public static enum MessageLevel {
        INFO,
        WARNING,
        ERROR,
        UNKNOWN;


        @JsonCreator
        public static MessageLevel forValue(String value) {
            try {
                return MessageLevel.valueOf(value);
            }
            catch (IllegalArgumentException ignore) {
                return UNKNOWN;
            }
        }
    }
}

