/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.state;

import com.spotify.styx.state.TriggerVisitor;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Trigger {
    private final TriggerAcceptor acceptor;
    private static final Trigger NATURAL = new Trigger(new NaturalCaseTriggerAcceptor());
    private static final TriggerFactory FACTORY = new TriggerFactory();

    private Trigger(TriggerAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    protected Trigger(@Nonnull Trigger implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.spotify.styx.state.Trigger");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    public static Trigger adhoc(@Nonnull String triggerId) {
        if (triggerId == null) {
            throw new NullPointerException("Argument shouldn't be null: 'triggerId' argument in static method invocation: 'adhoc' in class com.spotify.styx.state.Trigger");
        }
        return new Trigger(new AdhocCaseTriggerAcceptor(triggerId));
    }

    @Nonnull
    public static Trigger backfill(@Nonnull String triggerId) {
        if (triggerId == null) {
            throw new NullPointerException("Argument shouldn't be null: 'triggerId' argument in static method invocation: 'backfill' in class com.spotify.styx.state.Trigger");
        }
        return new Trigger(new BackfillCaseTriggerAcceptor(triggerId));
    }

    @Nonnull
    public static Trigger natural() {
        return NATURAL;
    }

    @Nonnull
    public static Trigger unknown(@Nonnull String triggerId) {
        if (triggerId == null) {
            throw new NullPointerException("Argument shouldn't be null: 'triggerId' argument in static method invocation: 'unknown' in class com.spotify.styx.state.Trigger");
        }
        return new Trigger(new UnknownCaseTriggerAcceptor(triggerId));
    }

    public final <R> R accept(TriggerVisitor<R> visitor) {
        return this.acceptor.accept(visitor);
    }

    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Trigger)) {
            return false;
        }
        Trigger that = (Trigger)thatObject;
        return this.acceptor.triggerEquals(that.acceptor);
    }

    public final int hashCode() {
        return this.acceptor.triggerHashCode();
    }

    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    public static TriggerVisitor<Trigger> factory() {
        return FACTORY;
    }

    private static class UnknownCaseTriggerAcceptor
    implements TriggerAcceptor {
        private final String triggerId;

        UnknownCaseTriggerAcceptor(String triggerId) {
            this.triggerId = triggerId;
        }

        @Override
        public <R> R accept(TriggerVisitor<R> visitor) {
            return visitor.unknown(this.triggerId);
        }

        @Override
        public boolean triggerEqualsAdhoc(String triggerId) {
            return false;
        }

        @Override
        public boolean triggerEqualsBackfill(String triggerId) {
            return false;
        }

        @Override
        public boolean triggerEqualsNatural() {
            return false;
        }

        @Override
        public final boolean triggerEquals(TriggerAcceptor thatAcceptor) {
            return thatAcceptor.triggerEqualsUnknown(this.triggerId);
        }

        @Override
        public boolean triggerEqualsUnknown(String triggerId) {
            return triggerId.equals(this.triggerId);
        }

        @Override
        public final int triggerHashCode() {
            int result = 4;
            result = result * 37 + this.triggerId.hashCode();
            return result;
        }

        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Trigger.Unknown{");
            result.append("triggerId = ");
            result.append(this.triggerId);
            result.append("}");
            return result.toString();
        }
    }

    private static class TriggerFactory
    implements TriggerVisitor<Trigger> {
        private TriggerFactory() {
        }

        @Override
        @Nonnull
        public Trigger adhoc(String triggerId) {
            return Trigger.adhoc(triggerId);
        }

        @Override
        @Nonnull
        public Trigger backfill(String triggerId) {
            return Trigger.backfill(triggerId);
        }

        @Override
        @Nonnull
        public Trigger natural() {
            return Trigger.natural();
        }

        @Override
        @Nonnull
        public Trigger unknown(String triggerId) {
            return Trigger.unknown(triggerId);
        }
    }

    private static interface TriggerAcceptor {
        public <R> R accept(TriggerVisitor<R> var1);

        public boolean triggerEquals(TriggerAcceptor var1);

        public boolean triggerEqualsAdhoc(String var1);

        public boolean triggerEqualsBackfill(String var1);

        public boolean triggerEqualsNatural();

        public boolean triggerEqualsUnknown(String var1);

        public int triggerHashCode();
    }

    private static class NaturalCaseTriggerAcceptor
    implements TriggerAcceptor {
        NaturalCaseTriggerAcceptor() {
        }

        @Override
        public <R> R accept(TriggerVisitor<R> visitor) {
            return visitor.natural();
        }

        @Override
        public boolean triggerEqualsAdhoc(String triggerId) {
            return false;
        }

        @Override
        public boolean triggerEqualsBackfill(String triggerId) {
            return false;
        }

        @Override
        public final boolean triggerEquals(TriggerAcceptor thatAcceptor) {
            return thatAcceptor.triggerEqualsNatural();
        }

        @Override
        public boolean triggerEqualsNatural() {
            return true;
        }

        @Override
        public boolean triggerEqualsUnknown(String triggerId) {
            return false;
        }

        @Override
        public final int triggerHashCode() {
            int result = 3;
            return result;
        }

        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Trigger.Natural{");
            result.append("}");
            return result.toString();
        }
    }

    private static class BackfillCaseTriggerAcceptor
    implements TriggerAcceptor {
        private final String triggerId;

        BackfillCaseTriggerAcceptor(String triggerId) {
            this.triggerId = triggerId;
        }

        @Override
        public <R> R accept(TriggerVisitor<R> visitor) {
            return visitor.backfill(this.triggerId);
        }

        @Override
        public boolean triggerEqualsAdhoc(String triggerId) {
            return false;
        }

        @Override
        public final boolean triggerEquals(TriggerAcceptor thatAcceptor) {
            return thatAcceptor.triggerEqualsBackfill(this.triggerId);
        }

        @Override
        public boolean triggerEqualsBackfill(String triggerId) {
            return triggerId.equals(this.triggerId);
        }

        @Override
        public boolean triggerEqualsNatural() {
            return false;
        }

        @Override
        public boolean triggerEqualsUnknown(String triggerId) {
            return false;
        }

        @Override
        public final int triggerHashCode() {
            int result = 2;
            result = result * 37 + this.triggerId.hashCode();
            return result;
        }

        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Trigger.Backfill{");
            result.append("triggerId = ");
            result.append(this.triggerId);
            result.append("}");
            return result.toString();
        }
    }

    private static class AdhocCaseTriggerAcceptor
    implements TriggerAcceptor {
        private final String triggerId;

        AdhocCaseTriggerAcceptor(String triggerId) {
            this.triggerId = triggerId;
        }

        @Override
        public <R> R accept(TriggerVisitor<R> visitor) {
            return visitor.adhoc(this.triggerId);
        }

        @Override
        public final boolean triggerEquals(TriggerAcceptor thatAcceptor) {
            return thatAcceptor.triggerEqualsAdhoc(this.triggerId);
        }

        @Override
        public boolean triggerEqualsAdhoc(String triggerId) {
            return triggerId.equals(this.triggerId);
        }

        @Override
        public boolean triggerEqualsBackfill(String triggerId) {
            return false;
        }

        @Override
        public boolean triggerEqualsNatural() {
            return false;
        }

        @Override
        public boolean triggerEqualsUnknown(String triggerId) {
            return false;
        }

        @Override
        public final int triggerHashCode() {
            int result = 1;
            result = result * 37 + this.triggerId.hashCode();
            return result;
        }

        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Trigger.Adhoc{");
            result.append("triggerId = ");
            result.append(this.triggerId);
            result.append("}");
            return result.toString();
        }
    }
}

