/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.automatter.jackson;

import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import io.norberg.automatter.AutoMatter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class AutoMatterResolver
extends AbstractTypeResolver {
    private static final String VALUE_SUFFIX = "Builder$Value";
    private final ConcurrentMap<Class<?>, JavaType> types = new ConcurrentHashMap();

    AutoMatterResolver() {
    }

    @Override
    public JavaType resolveAbstractType(DeserializationConfig config, JavaType type) {
        return this.resolveAbstractType0(config, type.getRawClass());
    }

    @Override
    public JavaType resolveAbstractType(DeserializationConfig config, BeanDescription typeDesc) {
        return this.resolveAbstractType0(config, typeDesc.getBeanClass());
    }

    private JavaType resolveAbstractType0(DeserializationConfig config, Class<?> rawClass) {
        Class<?> cls;
        AutoMatter annotation = rawClass.getAnnotation(AutoMatter.class);
        if (annotation == null) {
            return null;
        }
        JavaType cached = (JavaType)this.types.get(rawClass);
        if (cached != null) {
            return cached;
        }
        String packageName = rawClass.getPackage().getName();
        String name = rawClass.getSimpleName();
        String valueName = packageName + '.' + name + VALUE_SUFFIX;
        try {
            cls = Class.forName(valueName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No builder found for @AutoMatter type: " + name, e);
        }
        JavaType materialized = config.getTypeFactory().constructType(cls);
        JavaType existing = this.types.putIfAbsent(rawClass, materialized);
        return existing != null ? existing : materialized;
    }
}

