/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Function1;
import javaslang.Kind1;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.AbstractIterator;
import javaslang.collection.ArrayModule;
import javaslang.collection.Collections;
import javaslang.collection.HashMap;
import javaslang.collection.IndexedSeq;
import javaslang.collection.Iterator;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.control.Option;
import javaslang.\u03bb;

public final class Array<T>
implements Kind1<Array<?>, T>,
IndexedSeq<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Array<?> EMPTY = new Array(new Object[0]);
    private final Object[] back;

    private Array(Object[] back) {
        this.back = back;
    }

    static <T> Array<T> wrap(Object[] array) {
        if (array.length == 0) {
            return Array.empty();
        }
        return new Array<T>(array);
    }

    public static <T> Collector<T, ArrayList<T>, Array<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, Array> finisher = Array::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Array<T> empty() {
        return EMPTY;
    }

    public static <T> Array<T> narrow(Array<? extends T> array) {
        return array;
    }

    public static <T> Array<T> of(T element) {
        return Array.wrap(new Object[]{element});
    }

    @SafeVarargs
    public static <T> Array<T> of(T ... elements) {
        Objects.requireNonNull(elements, "elements is null");
        return Array.wrap(Arrays.copyOf(elements, elements.length));
    }

    public static <T> Array<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof Array) {
            return (Array)elements;
        }
        return Array.wrap(Array.create(elements));
    }

    public static Array<Boolean> ofAll(boolean[] array) {
        Objects.requireNonNull(array, "array is null");
        return Array.ofAll(Iterator.ofAll(array));
    }

    public static Array<Byte> ofAll(byte[] array) {
        Objects.requireNonNull(array, "array is null");
        return Array.ofAll(Iterator.ofAll(array));
    }

    public static Array<Character> ofAll(char[] array) {
        Objects.requireNonNull(array, "array is null");
        return Array.ofAll(Iterator.ofAll(array));
    }

    public static Array<Double> ofAll(double[] array) {
        Objects.requireNonNull(array, "array is null");
        return Array.ofAll(Iterator.ofAll(array));
    }

    public static Array<Float> ofAll(float[] array) {
        Objects.requireNonNull(array, "array is null");
        return Array.ofAll(Iterator.ofAll(array));
    }

    public static Array<Integer> ofAll(int[] array) {
        Objects.requireNonNull(array, "array is null");
        return Array.ofAll(Iterator.ofAll(array));
    }

    public static Array<Long> ofAll(long[] array) {
        Objects.requireNonNull(array, "array is null");
        return Array.ofAll(Iterator.ofAll(array));
    }

    public static Array<Short> ofAll(short[] array) {
        Objects.requireNonNull(array, "array is null");
        return Array.ofAll(Iterator.ofAll(array));
    }

    public static <T> Array<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f, Array.empty(), Array::of);
    }

    public static <T> Array<T> fill(int n, Supplier<? extends T> s2) {
        Objects.requireNonNull(s2, "s is null");
        return Collections.fill(n, s2, Array.empty(), Array::of);
    }

    public static Array<Character> range(char from, char toExclusive) {
        return Array.ofAll(Iterator.range(from, toExclusive));
    }

    public static Array<Character> rangeBy(char from, char toExclusive, int step) {
        return Array.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static Array<Double> rangeBy(double from, double toExclusive, double step) {
        return Array.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static Array<Integer> range(int from, int toExclusive) {
        return Array.ofAll(Iterator.range(from, toExclusive));
    }

    public static Array<Integer> rangeBy(int from, int toExclusive, int step) {
        return Array.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static Array<Long> range(long from, long toExclusive) {
        return Array.ofAll(Iterator.range(from, toExclusive));
    }

    public static Array<Long> rangeBy(long from, long toExclusive, long step) {
        return Array.ofAll(Iterator.rangeBy(from, toExclusive, step));
    }

    public static Array<Character> rangeClosed(char from, char toInclusive) {
        return Array.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static Array<Character> rangeClosedBy(char from, char toInclusive, int step) {
        return Array.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static Array<Double> rangeClosedBy(double from, double toInclusive, double step) {
        return Array.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static Array<Integer> rangeClosed(int from, int toInclusive) {
        return Array.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static Array<Integer> rangeClosedBy(int from, int toInclusive, int step) {
        return Array.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    public static Array<Long> rangeClosed(long from, long toInclusive) {
        return Array.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static Array<Long> rangeClosedBy(long from, long toInclusive, long step) {
        return Array.ofAll(Iterator.rangeClosedBy(from, toInclusive, step));
    }

    @Override
    public Array<T> append(T element) {
        Object[] arr = Arrays.copyOf(this.back, this.back.length + 1);
        arr[this.back.length] = element;
        return Array.wrap(arr);
    }

    @Override
    public Array<T> appendAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        Object[] source2 = Array.create(elements);
        if (source2.length == 0) {
            return this;
        }
        Object[] arr = Arrays.copyOf(this.back, this.back.length + source2.length);
        System.arraycopy(source2, 0, arr, this.back.length, source2.length);
        return Array.wrap(arr);
    }

    @Override
    public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new AbstractIterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Array.this.back.length;
            }

            @Override
            public T getNext() {
                return Array.this.back[this.index++];
            }
        };
    }

    @Override
    public Array<Array<T>> combinations() {
        return ((Array)Array.rangeClosed(0, this.length()).map((T n) -> this.combinations((int)n))).flatMap(Function.identity());
    }

    @Override
    public Array<Array<T>> combinations(int k) {
        return ArrayModule.Combinations.apply(this, Math.max(k, 0));
    }

    @Override
    public Iterator<Array<T>> crossProduct(int power) {
        return Collections.crossProduct(Array.empty(), this, power);
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("get(" + index + ")");
        }
        return (T)this.back[index];
    }

    @Override
    public Array<T> distinct() {
        return this.distinctBy(Function.identity());
    }

    @Override
    public Array<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        TreeSet<? super T> seen = new TreeSet<T>(comparator);
        return this.filter(seen::add);
    }

    @Override
    public <U> Array<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        HashSet seen = new HashSet();
        return this.filter((T t) -> seen.add(keyExtractor.apply(t)));
    }

    @Override
    public Array<T> drop(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return Array.empty();
        }
        Object[] arr = new Object[this.back.length - (int)n];
        System.arraycopy(this.back, (int)n, arr, 0, arr.length);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return Array.empty();
        }
        return Array.wrap(Arrays.copyOf(this.back, this.back.length - (int)n));
    }

    @Override
    public Array<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    public Array<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = 0; i < this.length(); ++i) {
            if (predicate.test(this.get(i))) continue;
            return this.drop(i);
        }
        return Array.empty();
    }

    @Override
    public Array<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        ArrayList list = new ArrayList();
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            list.add(t);
        }
        if (list.size() == this.back.length) {
            return this;
        }
        return list.isEmpty() ? Array.empty() : Array.wrap(list.toArray());
    }

    @Override
    public <U> Array<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isEmpty()) {
            return Array.empty();
        }
        ArrayList<U> list = new ArrayList<U>();
        for (Object t : this) {
            for (U u : mapper.apply(t)) {
                list.add(u);
            }
        }
        return Array.wrap(Array.create(list));
    }

    @Override
    public <C> Map<C, Array<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return this.foldLeft(HashMap.empty(), (map, t) -> {
            Object key = classifier.apply(t);
            Array<Object> values2 = map.get(key).map((T ts) -> ts.append(t)).getOrElse(Array.of(t));
            return map.put(key, values2);
        });
    }

    @Override
    public Iterator<Array<T>> grouped(long size) {
        return this.sliding(size, size);
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head() on empty Array");
        }
        return (T)this.back[0];
    }

    @Override
    public int indexOf(T element, int from) {
        for (int i = from; i < this.length(); ++i) {
            if (!Objects.equals(this.get(i), element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Array<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty Array");
        }
        Object[] arr = new Object[this.length() - 1];
        System.arraycopy(this.back, 0, arr, 0, arr.length);
        return Array.wrap(arr);
    }

    @Override
    public Option<Array<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public boolean isEmpty() {
        return this.back.length == 0;
    }

    private Object readResolve() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return this;
    }

    @Override
    public Array<T> insert(int index, T element) {
        if (index < 0 || index > this.length()) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e) on Array of length " + this.length());
        }
        Object[] arr = new Object[this.back.length + 1];
        System.arraycopy(this.back, 0, arr, 0, index);
        arr[index] = element;
        System.arraycopy(this.back, index, arr, index + 1, this.back.length - index);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> insertAll(int index, Iterable<? extends T> elements) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e)");
        }
        if (index > this.length()) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e) on Vector of length " + this.length());
        }
        Object[] list = Array.create(elements);
        if (list.length == 0) {
            return this;
        }
        Object[] arr = new Object[this.back.length + list.length];
        System.arraycopy(this.back, 0, arr, 0, index);
        System.arraycopy(list, 0, arr, index, list.length);
        System.arraycopy(this.back, index, arr, index + list.length, this.back.length - index);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> intersperse(T element) {
        if (this.back.length <= 1) {
            return this;
        }
        Object[] arr = new Object[this.back.length * 2 - 1];
        for (int i = 0; i < this.back.length; ++i) {
            arr[i * 2] = this.back[i];
            if (i <= 0) continue;
            arr[i * 2 - 1] = element;
        }
        return Array.wrap(arr);
    }

    @Override
    public int lastIndexOf(T element, int end) {
        for (int i = Math.min(end, this.length() - 1); i >= 0; --i) {
            if (!Objects.equals(this.get(i), element)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.back.length;
    }

    @Override
    public <U> Array<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        Object[] arr = new Object[this.length()];
        for (int i = 0; i < this.back.length; ++i) {
            arr[i] = mapper.apply(this.get(i));
        }
        return Array.wrap(arr);
    }

    @Override
    public Array<T> padTo(int length, T element) {
        if (length <= this.length()) {
            return this;
        }
        return this.appendAll((Iterable)Iterator.continually(element).take(length - this.length()));
    }

    @Override
    public Array<T> patch(int from, Iterable<? extends T> that, int replaced) {
        from = from < 0 ? 0 : from;
        replaced = replaced < 0 ? 0 : replaced;
        IndexedSeq result = ((Array)this.take(from)).appendAll((Iterable)that);
        result = ((Array)result).appendAll((Iterable)this.drop(from += replaced));
        return result;
    }

    @Override
    public Tuple2<Array<T>, Array<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        ArrayList left = new ArrayList();
        ArrayList right = new ArrayList();
        for (Object t : this) {
            (predicate.test(t) ? left : right).add(t);
        }
        return Tuple.of(Array.ofAll(left), Array.ofAll(right));
    }

    @Override
    public Array<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.head());
        }
        return this;
    }

    @Override
    public Array<Array<T>> permutations() {
        if (this.isEmpty()) {
            return Array.empty();
        }
        IndexedSeq tail = this.tail();
        if (((Array)tail).isEmpty()) {
            return Array.of(this);
        }
        Array<T> zero = Array.empty();
        return this.distinct().foldLeft(zero, (xs, x) -> {
            Function<Array, Array> prepend = l -> l.prepend(x);
            return xs.appendAll((Iterable)((Array)((Array)this.remove(x)).permutations()).map(prepend));
        });
    }

    @Override
    public Array<T> prepend(T element) {
        return this.insert(0, (Object)element);
    }

    @Override
    public Array<T> prependAll(Iterable<? extends T> elements) {
        return this.insertAll(0, (Iterable)elements);
    }

    @Override
    public Array<T> remove(T element) {
        int found = -1;
        for (int i = 0; i < this.length(); ++i) {
            T value = this.get(i);
            if (!element.equals(value)) continue;
            found = i;
            break;
        }
        if (found < 0) {
            return this;
        }
        return this.removeAt(found);
    }

    @Override
    public Array<T> removeFirst(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        int found = -1;
        for (int i = 0; i < this.length(); ++i) {
            T value = this.get(i);
            if (!predicate.test(value)) continue;
            found = i;
            break;
        }
        if (found < 0) {
            return this;
        }
        return this.removeAt(found);
    }

    @Override
    public Array<T> removeLast(Predicate<T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        int found = -1;
        for (int i = this.length() - 1; i >= 0; --i) {
            T value = this.get(i);
            if (!predicate.test(value)) continue;
            found = i;
            break;
        }
        if (found < 0) {
            return this;
        }
        return this.removeAt(found);
    }

    @Override
    public Array<T> removeAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("removeAt(" + index + ")");
        }
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException("removeAt(" + index + ")");
        }
        Object[] arr = new Object[this.length() - 1];
        System.arraycopy(this.back, 0, arr, 0, index);
        System.arraycopy(this.back, index + 1, arr, index, this.length() - index - 1);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> removeAll(T element) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.length(); ++i) {
            T value = this.get(i);
            if (element.equals(value)) continue;
            list.add(value);
        }
        if (list.size() == this.length()) {
            return this;
        }
        return Array.wrap(list.toArray());
    }

    @Override
    public Array<T> removeAll(Iterable<? extends T> elements) {
        HashSet<T> removed = new HashSet<T>();
        for (T element : elements) {
            removed.add(element);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.length(); ++i) {
            T value = this.get(i);
            if (removed.contains(value)) continue;
            list.add(value);
        }
        if (list.size() == this.length()) {
            return this;
        }
        return Array.wrap(list.toArray());
    }

    @Override
    public Array<T> replace(T currentElement, T newElement) {
        Object[] arr = new Object[this.length()];
        boolean found = false;
        for (int i = 0; i < this.length(); ++i) {
            T value = this.get(i);
            if (found) {
                arr[i] = this.back[i];
                continue;
            }
            if (currentElement.equals(value)) {
                arr[i] = newElement;
                found = true;
                continue;
            }
            arr[i] = this.back[i];
        }
        return found ? Array.wrap(arr) : this;
    }

    @Override
    public Array<T> replaceAll(T currentElement, T newElement) {
        Object[] arr = new Object[this.length()];
        boolean changed = false;
        for (int i = 0; i < this.length(); ++i) {
            T value = this.get(i);
            if (currentElement.equals(value)) {
                arr[i] = newElement;
                changed = true;
                continue;
            }
            arr[i] = this.back[i];
        }
        return changed ? Array.wrap(arr) : this;
    }

    @Override
    public Array<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        HashSet<T> kept = new HashSet<T>();
        for (T element : elements) {
            kept.add(element);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.length(); ++i) {
            T value = this.get(i);
            if (!kept.contains(value)) continue;
            list.add(value);
        }
        if (list.size() == this.length()) {
            return this;
        }
        return Array.wrap(list.toArray());
    }

    @Override
    public Array<T> reverse() {
        Object[] arr = new Object[this.back.length];
        for (int i = 0; i < this.back.length; ++i) {
            arr[this.back.length - 1 - i] = this.back[i];
        }
        return Array.wrap(arr);
    }

    @Override
    public Array<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    @Override
    public <U> Array<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return Collections.scanLeft(this, zero, operation, new ArrayList(), (c, u) -> {
            c.add(u);
            return c;
        }, list -> Array.wrap(list.toArray()));
    }

    @Override
    public <U> Array<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return Collections.scanRight(this, zero, operation, List.empty(), List::prepend, list -> Array.wrap(list.toJavaArray()));
    }

    @Override
    public Array<T> slice(long beginIndex, long endIndex) {
        if (beginIndex >= endIndex || beginIndex >= (long)this.length() || this.isEmpty()) {
            return Array.empty();
        }
        if (beginIndex <= 0L && endIndex >= (long)this.length()) {
            return this;
        }
        long index = Math.max(beginIndex, 0L);
        long length = Math.min(endIndex, (long)this.length()) - index;
        Object[] arr = new Object[(int)length];
        System.arraycopy(this.back, (int)index, arr, 0, (int)length);
        return Array.wrap(arr);
    }

    @Override
    public Iterator<Array<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    public Iterator<Array<T>> sliding(long size, long step) {
        return this.iterator().sliding(size, step).map(Array::ofAll);
    }

    @Override
    public Array<T> sorted() {
        Object[] arr = Arrays.copyOf(this.back, this.back.length);
        Arrays.sort(arr);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> sorted(Comparator<? super T> comparator) {
        Object[] arr = Arrays.copyOf(this.back, this.back.length);
        Arrays.sort(arr, (o1, o2) -> comparator.compare(o1, o2));
        return Array.wrap(arr);
    }

    @Override
    public <U extends Comparable<? super U>> Array<T> sortBy(Function<? super T, ? extends U> mapper) {
        return this.sortBy(Comparable::compareTo, (Function)mapper);
    }

    @Override
    public <U> Array<T> sortBy(Comparator<? super U> comparator, Function<? super T, ? extends U> mapper) {
        \u03bb domain = Function1.of(mapper::apply).memoized();
        return this.toJavaStream().sorted((arg_0, arg_1) -> Array.lambda$sortBy$10(comparator, (Function)((Object)domain), arg_0, arg_1)).collect(Array.collector());
    }

    @Override
    public Tuple2<Array<T>, Array<T>> splitAt(long n) {
        return Tuple.of(this.take(n), this.drop(n));
    }

    @Override
    public Tuple2<Array<T>, Array<T>> splitAt(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        IndexedSeq init = this.takeWhile((Predicate)predicate.negate());
        return Tuple.of(init, this.drop(((Array)init).length()));
    }

    @Override
    public Tuple2<Array<T>, Array<T>> splitAtInclusive(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = 0; i < this.back.length; ++i) {
            T value = this.get(i);
            if (!predicate.test(value)) continue;
            if (i == this.back.length - 1) {
                return Tuple.of(this, Array.empty());
            }
            return Tuple.of(this.take(i + 1), this.drop(i + 1));
        }
        return Tuple.of(this, Array.empty());
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    public Tuple2<Array<T>, Array<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return Tuple.of(this.takeWhile((Predicate)predicate), this.dropWhile((Predicate)predicate));
    }

    @Override
    public Array<T> subSequence(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ")");
        }
        if (beginIndex > this.length()) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ")");
        }
        return this.drop(beginIndex);
    }

    @Override
    public Array<T> subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > this.length()) {
            throw new IndexOutOfBoundsException(String.format("subSequence(%s, %s) on List of length %s", beginIndex, endIndex, this.length()));
        }
        if (beginIndex == endIndex) {
            return Array.empty();
        }
        Object[] arr = new Object[endIndex - beginIndex];
        System.arraycopy(this.back, beginIndex, arr, 0, arr.length);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail() on empty Array");
        }
        Object[] arr = new Object[this.back.length - 1];
        System.arraycopy(this.back, 1, arr, 0, arr.length);
        return Array.wrap(arr);
    }

    @Override
    public Option<Array<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    public Array<T> take(long n) {
        if (n >= (long)this.length()) {
            return this;
        }
        if (n <= 0L) {
            return Array.empty();
        }
        return Array.wrap(Arrays.copyOf(this.back, (int)n));
    }

    @Override
    public Array<T> takeRight(long n) {
        if (n >= (long)this.length()) {
            return this;
        }
        if (n <= 0L) {
            return Array.empty();
        }
        Object[] arr = new Object[(int)n];
        System.arraycopy(this.back, this.back.length - (int)n, arr, 0, (int)n);
        return Array.wrap(arr);
    }

    @Override
    public Array<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.takeWhile((Predicate)predicate.negate());
    }

    @Override
    public Array<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        for (int i = 0; i < this.back.length; ++i) {
            T value = this.get(i);
            if (predicate.test(value)) continue;
            return this.take(i);
        }
        return this;
    }

    public <U> U transform(Function<? super Array<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @Override
    public <U> Array<U> unit(Iterable<? extends U> iterable) {
        return Array.ofAll(iterable);
    }

    @Override
    public <T1, T2> Tuple2<Array<T1>, Array<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        if (this.isEmpty()) {
            return Tuple.of(Array.empty(), Array.empty());
        }
        Object[] xs = new Object[this.back.length];
        Object[] ys = new Object[this.back.length];
        for (int i = 0; i < this.back.length; ++i) {
            Tuple2<? extends T1, ? extends T2> t = unzipper.apply(this.get(i));
            xs[i] = t._1;
            ys[i] = t._2;
        }
        return Tuple.of(Array.wrap(xs), Array.wrap(ys));
    }

    @Override
    public <T1, T2, T3> Tuple3<Array<T1>, Array<T2>, Array<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        if (this.isEmpty()) {
            return Tuple.of(Array.empty(), Array.empty(), Array.empty());
        }
        Object[] xs = new Object[this.back.length];
        Object[] ys = new Object[this.back.length];
        Object[] zs = new Object[this.back.length];
        for (int i = 0; i < this.back.length; ++i) {
            Tuple3<? extends T1, ? extends T2, ? extends T3> t = unzipper.apply(this.get(i));
            xs[i] = t._1;
            ys[i] = t._2;
            zs[i] = t._3;
        }
        return Tuple.of(Array.wrap(xs), Array.wrap(ys), Array.wrap(zs));
    }

    @Override
    public Array<T> update(int index, T element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("update(" + index + ")");
        }
        if (index >= this.length()) {
            throw new IndexOutOfBoundsException("update(" + index + ")");
        }
        Object[] arr = Array.create(this);
        arr[index] = element;
        return Array.wrap(arr);
    }

    @Override
    public <U> Array<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        return Array.ofAll(this.iterator().zip(that));
    }

    @Override
    public <U> Array<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return Array.ofAll(this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    public Array<Tuple2<T, Long>> zipWithIndex() {
        return Array.ofAll(this.iterator().zipWithIndex());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Array) {
            Object[] arr1 = this.back;
            Object[] arr2 = ((Array)o).back;
            return Objects.deepEquals(arr1, arr2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.back);
    }

    @Override
    public String stringPrefix() {
        return "Array";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <T> Object[] create(Iterable<T> elements) {
        if (elements instanceof java.util.List) {
            java.util.List list = (java.util.List)elements;
            return list.toArray();
        }
        java.util.Iterator<T> it = elements.iterator();
        ArrayList<T> list = new ArrayList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray();
    }

    private static /* synthetic */ int lambda$sortBy$10(Comparator comparator, Function domain, Object e1, Object e2) {
        return comparator.compare(domain.apply(e1), domain.apply(e2));
    }
}

