/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.Collections;
import javaslang.collection.HashMap;
import javaslang.collection.Iterator;
import javaslang.collection.LinearSeq;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.collection.Seq;
import javaslang.collection.Stream;
import javaslang.collection.Traversable;
import javaslang.collection.TreeModule;
import javaslang.control.Option;

public interface Tree<T>
extends Traversable<T>,
Serializable {
    public static final long serialVersionUID = 1L;

    public static <T> Collector<T, ArrayList<T>, Tree<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, Tree> finisher = Tree::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Empty<T> empty() {
        return Empty.instance();
    }

    public static <T> Tree<T> narrow(Tree<? extends T> tree) {
        return tree;
    }

    public static <T> Node<T> of(T value) {
        return new Node<T>(value, List.empty());
    }

    @SafeVarargs
    public static <T> Node<T> of(T value, Node<T> ... children) {
        Objects.requireNonNull(children, "children is null");
        return new Node<T>(value, List.of(children));
    }

    public static <T> Node<T> of(T value, Iterable<Node<T>> children) {
        Objects.requireNonNull(children, "children is null");
        return new Node<T>(value, List.ofAll(children));
    }

    @SafeVarargs
    public static <T> Tree<T> of(T ... values2) {
        Objects.requireNonNull(values2, "values is null");
        List<T> list = List.of(values2);
        return list.isEmpty() ? Empty.instance() : new Node(list.head(), list.tail().map(Tree::of));
    }

    public static <T> Tree<T> ofAll(Iterable<? extends T> iterable) {
        Objects.requireNonNull(iterable, "iterable is null");
        if (iterable instanceof Tree) {
            return (Tree)iterable;
        }
        List<T> list = List.ofAll(iterable);
        return list.isEmpty() ? Empty.instance() : new Node(list.head(), list.tail().map(Tree::of));
    }

    public static <T> Tree<T> tabulate(int n, Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        return Collections.tabulate(n, f, Tree.empty(), Tree::of);
    }

    public static <T> Tree<T> fill(int n, Supplier<? extends T> s2) {
        Objects.requireNonNull(s2, "s is null");
        return Collections.fill(n, s2, Tree.empty(), Tree::of);
    }

    public T getValue();

    public List<Node<T>> getChildren();

    public boolean isLeaf();

    default public boolean isBranch() {
        return !this.isEmpty() && !this.isLeaf();
    }

    default public Iterator<T> iterator(Order order) {
        return this.values(order).iterator();
    }

    @Override
    public int size();

    default public <U> U transform(Function<? super Tree<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    default public Seq<Node<T>> traverse() {
        return this.traverse(Order.PRE_ORDER);
    }

    default public Seq<Node<T>> traverse(Order order) {
        Objects.requireNonNull(order, "order is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        Node node = (Node)this;
        switch (order) {
            case PRE_ORDER: {
                return TreeModule.Traversal.preOrder(node);
            }
            case IN_ORDER: {
                return TreeModule.Traversal.inOrder(node);
            }
            case POST_ORDER: {
                return TreeModule.Traversal.postOrder(node);
            }
            case LEVEL_ORDER: {
                return TreeModule.Traversal.levelOrder(node);
            }
        }
        throw new IllegalStateException("Unknown order: " + order.name());
    }

    default public Seq<T> values() {
        return this.traverse(Order.PRE_ORDER).map(Node::getValue);
    }

    default public Seq<T> values(Order order) {
        return this.traverse(order).map(Node::getValue);
    }

    default public int branchCount() {
        if (this.isEmpty() || this.isLeaf()) {
            return 0;
        }
        return this.getChildren().foldLeft(1, (count, child) -> count + child.branchCount());
    }

    default public int leafCount() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isLeaf()) {
            return 1;
        }
        return this.getChildren().foldLeft(0, (count, child) -> count + child.leafCount());
    }

    default public int nodeCount() {
        if (this.isEmpty()) {
            return 0;
        }
        return 1 + this.getChildren().foldLeft(0, (count, child) -> count + child.nodeCount());
    }

    @Override
    default public Seq<T> distinct() {
        return this.values().distinct();
    }

    @Override
    default public Seq<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().distinctBy((Comparator)comparator);
    }

    @Override
    default public <U> Seq<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().distinctBy(keyExtractor);
    }

    @Override
    default public Seq<T> drop(long n) {
        if (n >= (long)this.length()) {
            return Stream.empty();
        }
        return this.values().drop(n);
    }

    @Override
    default public Seq<T> dropRight(long n) {
        if (n >= (long)this.length()) {
            return Stream.empty();
        }
        return this.values().dropRight(n);
    }

    @Override
    default public Seq<T> dropUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.dropWhile((Predicate)predicate.negate());
    }

    @Override
    default public Seq<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().dropWhile((Predicate)predicate);
    }

    @Override
    default public Seq<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().filter((Predicate)predicate);
    }

    @Override
    default public <U> Tree<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Empty.instance() : TreeModule.FlatMap.apply((Node)this, mapper);
    }

    @Override
    default public <U> U foldRight(U zero, BiFunction<? super T, ? super U, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        if (this.isEmpty()) {
            return zero;
        }
        return this.iterator().foldRight(zero, f);
    }

    @Override
    default public <C> Map<C, Seq<T>> groupBy(Function<? super T, ? extends C> classifier) {
        Objects.requireNonNull(classifier, "classifier is null");
        if (this.isEmpty()) {
            return HashMap.empty();
        }
        return this.values().groupBy(classifier);
    }

    @Override
    default public Iterator<Seq<T>> grouped(long size) {
        return this.sliding(size, size);
    }

    @Override
    default public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    default public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty tree");
        }
        return (T)this.iterator().next();
    }

    @Override
    default public Seq<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty tree");
        }
        return this.values().init();
    }

    @Override
    default public Option<Seq<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.values().iterator();
    }

    @Override
    default public int length() {
        return this.size();
    }

    @Override
    default public <U> Tree<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.isEmpty() ? Empty.instance() : TreeModule.Map.apply((Node)this, mapper);
    }

    @Override
    default public Tuple2<Seq<T>, Seq<T>> partition(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Tuple.of(Stream.empty(), Stream.empty());
        }
        return this.values().partition(predicate);
    }

    @Override
    default public Tree<T> peek(Consumer<? super T> action) {
        Objects.requireNonNull(action, "action is null");
        if (!this.isEmpty()) {
            action.accept(this.head());
        }
        return this;
    }

    @Override
    default public Tree<T> replace(T currentElement, T newElement) {
        if (this.isEmpty()) {
            return Empty.instance();
        }
        return TreeModule.Replace.apply((Node)this, currentElement, newElement);
    }

    @Override
    default public Tree<T> replaceAll(T currentElement, T newElement) {
        return this.map((T t) -> Objects.equals(t, currentElement) ? newElement : t);
    }

    @Override
    default public Seq<T> retainAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        return this.values().retainAll((Iterable)elements);
    }

    @Override
    default public Seq<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation) {
        return this.scanLeft(zero, operation);
    }

    @Override
    default public <U> Seq<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return Collections.scanLeft(this, zero, operation, List.empty(), List::prepend, List::reverse);
    }

    @Override
    default public <U> Seq<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        Objects.requireNonNull(operation, "operation is null");
        return (Seq)Collections.scanRight(this, zero, operation, List.empty(), List::prepend, Function.identity());
    }

    @Override
    default public Iterator<Seq<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    default public Iterator<Seq<T>> sliding(long size, long step) {
        return this.iterator().sliding(size, step);
    }

    @Override
    default public Tuple2<Seq<T>, Seq<T>> span(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        if (this.isEmpty()) {
            return Tuple.of(Stream.empty(), Stream.empty());
        }
        return this.values().span(predicate);
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    default public String stringPrefix() {
        return "Tree";
    }

    @Override
    default public Seq<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty tree");
        }
        return this.values().tail();
    }

    @Override
    default public Option<Seq<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    default public Seq<T> take(long n) {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().take(n);
    }

    @Override
    default public Seq<T> takeRight(long n) {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return this.values().takeRight(n);
    }

    @Override
    default public Seq<T> takeUntil(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.values().takeUntil((Predicate)predicate);
    }

    @Override
    default public Seq<T> takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return this.values().takeWhile((Predicate)predicate);
    }

    @Override
    default public <T1, T2> Tuple2<Tree<T1>, Tree<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        if (this.isEmpty()) {
            return Tuple.of(Empty.instance(), Empty.instance());
        }
        return TreeModule.Unzip.apply((Node)this, unzipper);
    }

    @Override
    default public <T1, T2, T3> Tuple3<Tree<T1>, Tree<T2>, Tree<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        if (this.isEmpty()) {
            return Tuple.of(Empty.instance(), Empty.instance(), Empty.instance());
        }
        return TreeModule.Unzip.apply3((Node)this, unzipper);
    }

    @Override
    default public <U> Tree<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        if (this.isEmpty()) {
            return Empty.instance();
        }
        return TreeModule.Zip.apply((Node)this, that.iterator());
    }

    @Override
    default public <U> Tree<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        if (this.isEmpty()) {
            return Iterator.ofAll(that).map((T elem) -> Tuple.of(thisElem, elem)).toTree();
        }
        java.util.Iterator<U> thatIter = that.iterator();
        Tree<Tuple2<T, U>> tree = TreeModule.ZipAll.apply((Node)this, thatIter, thatElem);
        if (thatIter.hasNext()) {
            Traversable remainder = Iterator.ofAll(thatIter).map((T elem) -> Tree.of(Tuple.of(thisElem, elem)));
            return new Node<Tuple2<T, U>>(tree.getValue(), tree.getChildren().appendAll((Iterable)remainder));
        }
        return tree;
    }

    @Override
    default public Tree<Tuple2<T, Long>> zipWithIndex() {
        return this.zip(Iterator.from(0L));
    }

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    @Override
    public String toString();

    public String draw();

    public static enum Order {
        PRE_ORDER,
        IN_ORDER,
        POST_ORDER,
        LEVEL_ORDER;

    }

    public static final class Empty<T>
    implements Tree<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Empty<?> INSTANCE = new Empty();

        private Empty() {
        }

        public static <T> Empty<T> instance() {
            return INSTANCE;
        }

        @Override
        public List<Node<T>> getChildren() {
            return List.Nil.instance();
        }

        @Override
        public T getValue() {
            throw new UnsupportedOperationException("getValue of empty Tree");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }

        @Override
        public String draw() {
            return "\u25a3";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static final class Node<T>
    implements Tree<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final T value;
        private final List<Node<T>> children;

        public Node(T value, List<Node<T>> children) {
            Objects.requireNonNull(children, "children is null");
            this.value = value;
            this.children = children;
        }

        @Override
        public List<Node<T>> getChildren() {
            return this.children;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        @Override
        public int size() {
            return 1 + this.children.foldLeft(0, (acc, child) -> acc + child.length());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Node) {
                Node that = (Node)o;
                return Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getChildren(), that.getChildren());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.children);
        }

        @Override
        public String toString() {
            return this.stringPrefix() + (this.isLeaf() ? "(" + this.value + ")" : Node.toLispString(this));
        }

        @Override
        public String draw() {
            StringBuilder builder = new StringBuilder();
            this.drawAux("", builder);
            return builder.toString();
        }

        private void drawAux(String indent, StringBuilder builder) {
            builder.append(this.value);
            LinearSeq<Node<T>> it = this.children;
            while (!it.isEmpty()) {
                boolean isLast = it.tail().isEmpty();
                builder.append('\n').append(indent).append(isLast ? "\u2514\u2500\u2500" : "\u251c\u2500\u2500");
                ((Node)it.head()).drawAux(indent + (isLast ? "   " : "\u2502  "), builder);
                it = it.tail();
            }
        }

        private static String toLispString(Tree<?> tree) {
            String value = String.valueOf(tree.getValue());
            if (tree.isLeaf()) {
                return value;
            }
            return String.format("(%s %s)", value, tree.getChildren().map(Node::toLispString).mkString(" "));
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        private static final class SerializationProxy<T>
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient Node<T> node;

            SerializationProxy(Node<T> node) {
                this.node = node;
            }

            private void writeObject(ObjectOutputStream s2) throws IOException {
                s2.defaultWriteObject();
                s2.writeObject(((Node)this.node).value);
                s2.writeObject(((Node)this.node).children);
            }

            private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
                s2.defaultReadObject();
                Object value = s2.readObject();
                List children = (List)s2.readObject();
                this.node = new Node<Object>(value, children);
            }

            private Object readResolve() {
                return this.node;
            }
        }
    }
}

