/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Partitioning;
import com.spotify.styx.model.WorkflowId;
import io.norberg.automatter.AutoMatter;
import java.time.Instant;

public final class BackfillBuilder {
    private String id;
    private Instant start;
    private Instant end;
    private WorkflowId workflowId;
    private int concurrency;
    private String resource;
    private Instant nextTrigger;
    private Partitioning partitioning;
    private boolean completed;
    private boolean halted;

    public BackfillBuilder() {
    }

    private BackfillBuilder(Backfill v) {
        this.id = v.id();
        this.start = v.start();
        this.end = v.end();
        this.workflowId = v.workflowId();
        this.concurrency = v.concurrency();
        this.resource = v.resource();
        this.nextTrigger = v.nextTrigger();
        this.partitioning = v.partitioning();
        this.completed = v.completed();
        this.halted = v.halted();
    }

    private BackfillBuilder(BackfillBuilder v) {
        this.id = v.id;
        this.start = v.start;
        this.end = v.end;
        this.workflowId = v.workflowId;
        this.concurrency = v.concurrency;
        this.resource = v.resource;
        this.nextTrigger = v.nextTrigger;
        this.partitioning = v.partitioning;
        this.completed = v.completed;
        this.halted = v.halted;
    }

    public String id() {
        return this.id;
    }

    public BackfillBuilder id(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        return this;
    }

    public Instant start() {
        return this.start;
    }

    public BackfillBuilder start(Instant start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        this.start = start;
        return this;
    }

    public Instant end() {
        return this.end;
    }

    public BackfillBuilder end(Instant end) {
        if (end == null) {
            throw new NullPointerException("end");
        }
        this.end = end;
        return this;
    }

    public WorkflowId workflowId() {
        return this.workflowId;
    }

    public BackfillBuilder workflowId(WorkflowId workflowId) {
        if (workflowId == null) {
            throw new NullPointerException("workflowId");
        }
        this.workflowId = workflowId;
        return this;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public BackfillBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public String resource() {
        return this.resource;
    }

    public BackfillBuilder resource(String resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        this.resource = resource;
        return this;
    }

    public Instant nextTrigger() {
        return this.nextTrigger;
    }

    public BackfillBuilder nextTrigger(Instant nextTrigger) {
        if (nextTrigger == null) {
            throw new NullPointerException("nextTrigger");
        }
        this.nextTrigger = nextTrigger;
        return this;
    }

    public Partitioning partitioning() {
        return this.partitioning;
    }

    public BackfillBuilder partitioning(Partitioning partitioning) {
        if (partitioning == null) {
            throw new NullPointerException("partitioning");
        }
        this.partitioning = partitioning;
        return this;
    }

    public boolean completed() {
        return this.completed;
    }

    public BackfillBuilder completed(boolean completed) {
        this.completed = completed;
        return this;
    }

    public boolean halted() {
        return this.halted;
    }

    public BackfillBuilder halted(boolean halted) {
        this.halted = halted;
        return this;
    }

    public BackfillBuilder builder() {
        return new BackfillBuilder(this);
    }

    public Backfill build() {
        return new Value(this.id, this.start, this.end, this.workflowId, this.concurrency, this.resource, this.nextTrigger, this.partitioning, this.completed, this.halted);
    }

    public static BackfillBuilder from(Backfill v) {
        return new BackfillBuilder(v);
    }

    public static BackfillBuilder from(BackfillBuilder v) {
        return new BackfillBuilder(v);
    }

    private static final class Value
    implements Backfill {
        private final String id;
        private final Instant start;
        private final Instant end;
        private final WorkflowId workflowId;
        private final int concurrency;
        private final String resource;
        private final Instant nextTrigger;
        private final Partitioning partitioning;
        private final boolean completed;
        private final boolean halted;

        private Value(@AutoMatter.Field(value="id") String id, @AutoMatter.Field(value="start") Instant start, @AutoMatter.Field(value="end") Instant end, @AutoMatter.Field(value="workflowId") WorkflowId workflowId, @AutoMatter.Field(value="concurrency") int concurrency, @AutoMatter.Field(value="resource") String resource, @AutoMatter.Field(value="nextTrigger") Instant nextTrigger, @AutoMatter.Field(value="partitioning") Partitioning partitioning, @AutoMatter.Field(value="completed") boolean completed, @AutoMatter.Field(value="halted") boolean halted) {
            if (id == null) {
                throw new NullPointerException("id");
            }
            if (start == null) {
                throw new NullPointerException("start");
            }
            if (end == null) {
                throw new NullPointerException("end");
            }
            if (workflowId == null) {
                throw new NullPointerException("workflowId");
            }
            if (resource == null) {
                throw new NullPointerException("resource");
            }
            if (nextTrigger == null) {
                throw new NullPointerException("nextTrigger");
            }
            if (partitioning == null) {
                throw new NullPointerException("partitioning");
            }
            this.id = id;
            this.start = start;
            this.end = end;
            this.workflowId = workflowId;
            this.concurrency = concurrency;
            this.resource = resource;
            this.nextTrigger = nextTrigger;
            this.partitioning = partitioning;
            this.completed = completed;
            this.halted = halted;
        }

        @Override
        @AutoMatter.Field
        public String id() {
            return this.id;
        }

        @Override
        @AutoMatter.Field
        public Instant start() {
            return this.start;
        }

        @Override
        @AutoMatter.Field
        public Instant end() {
            return this.end;
        }

        @Override
        @AutoMatter.Field
        public WorkflowId workflowId() {
            return this.workflowId;
        }

        @Override
        @AutoMatter.Field
        public int concurrency() {
            return this.concurrency;
        }

        @Override
        @AutoMatter.Field
        public String resource() {
            return this.resource;
        }

        @Override
        @AutoMatter.Field
        public Instant nextTrigger() {
            return this.nextTrigger;
        }

        @Override
        @AutoMatter.Field
        public Partitioning partitioning() {
            return this.partitioning;
        }

        @Override
        @AutoMatter.Field
        public boolean completed() {
            return this.completed;
        }

        @Override
        @AutoMatter.Field
        public boolean halted() {
            return this.halted;
        }

        @Override
        public BackfillBuilder builder() {
            return new BackfillBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Backfill)) {
                return false;
            }
            Backfill that = (Backfill)o;
            if (this.id != null ? !this.id.equals(that.id()) : that.id() != null) {
                return false;
            }
            if (this.start != null ? !this.start.equals(that.start()) : that.start() != null) {
                return false;
            }
            if (this.end != null ? !this.end.equals(that.end()) : that.end() != null) {
                return false;
            }
            if (this.workflowId != null ? !this.workflowId.equals(that.workflowId()) : that.workflowId() != null) {
                return false;
            }
            if (this.concurrency != that.concurrency()) {
                return false;
            }
            if (this.resource != null ? !this.resource.equals(that.resource()) : that.resource() != null) {
                return false;
            }
            if (this.nextTrigger != null ? !this.nextTrigger.equals(that.nextTrigger()) : that.nextTrigger() != null) {
                return false;
            }
            if (this.partitioning != null ? !this.partitioning.equals((Object)that.partitioning()) : that.partitioning() != null) {
                return false;
            }
            if (this.completed != that.completed()) {
                return false;
            }
            return this.halted == that.halted();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            result = 31 * result + (this.workflowId != null ? this.workflowId.hashCode() : 0);
            result = 31 * result + this.concurrency;
            result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
            result = 31 * result + (this.nextTrigger != null ? this.nextTrigger.hashCode() : 0);
            result = 31 * result + (this.partitioning != null ? this.partitioning.hashCode() : 0);
            result = 31 * result + (this.completed ? 1231 : 1237);
            result = 31 * result + (this.halted ? 1231 : 1237);
            return result;
        }

        public String toString() {
            return "Backfill{id=" + this.id + ", start=" + this.start + ", end=" + this.end + ", workflowId=" + this.workflowId + ", concurrency=" + this.concurrency + ", resource=" + this.resource + ", nextTrigger=" + this.nextTrigger + ", partitioning=" + (Object)((Object)this.partitioning) + ", completed=" + this.completed + ", halted=" + this.halted + '}';
        }
    }
}

