/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.BackfillInput;
import io.norberg.automatter.AutoMatter;
import java.time.Instant;

public final class BackfillInputBuilder {
    private Instant start;
    private Instant end;
    private String component;
    private String workflow;
    private int concurrency;

    public BackfillInputBuilder() {
    }

    private BackfillInputBuilder(BackfillInput v) {
        this.start = v.start();
        this.end = v.end();
        this.component = v.component();
        this.workflow = v.workflow();
        this.concurrency = v.concurrency();
    }

    private BackfillInputBuilder(BackfillInputBuilder v) {
        this.start = v.start;
        this.end = v.end;
        this.component = v.component;
        this.workflow = v.workflow;
        this.concurrency = v.concurrency;
    }

    public Instant start() {
        return this.start;
    }

    public BackfillInputBuilder start(Instant start) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        this.start = start;
        return this;
    }

    public Instant end() {
        return this.end;
    }

    public BackfillInputBuilder end(Instant end) {
        if (end == null) {
            throw new NullPointerException("end");
        }
        this.end = end;
        return this;
    }

    public String component() {
        return this.component;
    }

    public BackfillInputBuilder component(String component) {
        if (component == null) {
            throw new NullPointerException("component");
        }
        this.component = component;
        return this;
    }

    public String workflow() {
        return this.workflow;
    }

    public BackfillInputBuilder workflow(String workflow) {
        if (workflow == null) {
            throw new NullPointerException("workflow");
        }
        this.workflow = workflow;
        return this;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public BackfillInputBuilder concurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public BackfillInputBuilder builder() {
        return new BackfillInputBuilder(this);
    }

    public BackfillInput build() {
        return new Value(this.start, this.end, this.component, this.workflow, this.concurrency);
    }

    public static BackfillInputBuilder from(BackfillInput v) {
        return new BackfillInputBuilder(v);
    }

    public static BackfillInputBuilder from(BackfillInputBuilder v) {
        return new BackfillInputBuilder(v);
    }

    private static final class Value
    implements BackfillInput {
        private final Instant start;
        private final Instant end;
        private final String component;
        private final String workflow;
        private final int concurrency;

        private Value(@AutoMatter.Field(value="start") Instant start, @AutoMatter.Field(value="end") Instant end, @AutoMatter.Field(value="component") String component, @AutoMatter.Field(value="workflow") String workflow, @AutoMatter.Field(value="concurrency") int concurrency) {
            if (start == null) {
                throw new NullPointerException("start");
            }
            if (end == null) {
                throw new NullPointerException("end");
            }
            if (component == null) {
                throw new NullPointerException("component");
            }
            if (workflow == null) {
                throw new NullPointerException("workflow");
            }
            this.start = start;
            this.end = end;
            this.component = component;
            this.workflow = workflow;
            this.concurrency = concurrency;
        }

        @Override
        @AutoMatter.Field
        public Instant start() {
            return this.start;
        }

        @Override
        @AutoMatter.Field
        public Instant end() {
            return this.end;
        }

        @Override
        @AutoMatter.Field
        public String component() {
            return this.component;
        }

        @Override
        @AutoMatter.Field
        public String workflow() {
            return this.workflow;
        }

        @Override
        @AutoMatter.Field
        public int concurrency() {
            return this.concurrency;
        }

        @Override
        public BackfillInputBuilder builder() {
            return new BackfillInputBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BackfillInput)) {
                return false;
            }
            BackfillInput that = (BackfillInput)o;
            if (this.start != null ? !this.start.equals(that.start()) : that.start() != null) {
                return false;
            }
            if (this.end != null ? !this.end.equals(that.end()) : that.end() != null) {
                return false;
            }
            if (this.component != null ? !this.component.equals(that.component()) : that.component() != null) {
                return false;
            }
            if (this.workflow != null ? !this.workflow.equals(that.workflow()) : that.workflow() != null) {
                return false;
            }
            return this.concurrency == that.concurrency();
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
            result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
            result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
            result = 31 * result + (this.workflow != null ? this.workflow.hashCode() : 0);
            result = 31 * result + this.concurrency;
            return result;
        }

        public String toString() {
            return "BackfillInput{start=" + this.start + ", end=" + this.end + ", component=" + this.component + ", workflow=" + this.workflow + ", concurrency=" + this.concurrency + '}';
        }
    }
}

