/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.styx.model.AutoValue_WorkflowId;
import com.spotify.styx.model.Workflow;
import java.util.Comparator;

public abstract class WorkflowId {
    public static final Comparator<WorkflowId> KEY_COMPARATOR = (a, b) -> a.toKey().compareTo(b.toKey());

    @JsonProperty
    public abstract String componentId();

    @JsonProperty
    public abstract String endpointId();

    public String toKey() {
        return this.componentId() + "#" + this.endpointId();
    }

    @JsonCreator
    public static WorkflowId create(@JsonProperty(value="component_id") String componentId, @JsonProperty(value="endpoint_id") String endpointId) {
        return new AutoValue_WorkflowId(componentId, endpointId);
    }

    public static WorkflowId ofWorkflow(Workflow workflow) {
        return new AutoValue_WorkflowId(workflow.componentId(), workflow.endpointId());
    }

    public static WorkflowId parseKey(String key) {
        int hashPos = key.indexOf(35);
        if (hashPos < 1) {
            throw new IllegalArgumentException("Key must contain a hash '#' sign on position > 0");
        }
        return WorkflowId.create(key.substring(0, hashPos), key.substring(hashPos + 1));
    }
}

