/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model.data;

import com.spotify.styx.model.EventVisitor;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.data.ExecStatus;
import com.spotify.styx.model.data.Execution;
import com.spotify.styx.model.data.Trigger;
import com.spotify.styx.model.data.WorkflowInstanceExecutionData;
import com.spotify.styx.state.Message;
import com.spotify.styx.util.TriggerUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

class WFIExecutionBuilder {
    private List<Trigger> triggerList = new ArrayList<Trigger>();
    private List<Execution> executionList = new ArrayList<Execution>();
    private List<ExecStatus> executionStatusList = new ArrayList<ExecStatus>();
    private WorkflowInstance currWorkflowInstance;
    private String currExecutionId;
    private String currTriggerId;
    private String currDockerImg;
    private boolean completed;
    private Instant triggerTs;
    private Instant eventTs;
    private final EventVisitor visitor = new Reducer();

    WFIExecutionBuilder() {
    }

    private void closeExecution() {
        if (this.currExecutionId != null && this.currDockerImg != null) {
            Execution execution = Execution.create(this.currExecutionId, this.currDockerImg, this.executionStatusList);
            this.executionList.add(execution);
        }
        this.executionStatusList = new ArrayList<ExecStatus>();
        this.currExecutionId = null;
        this.currDockerImg = null;
    }

    private void closeTrigger() {
        if (!this.executionStatusList.isEmpty()) {
            this.closeExecution();
        }
        Trigger trigger = Trigger.create(this.currTriggerId, this.triggerTs, this.completed, this.executionList);
        this.triggerList.add(trigger);
        this.executionList = new ArrayList<Execution>();
    }

    WorkflowInstanceExecutionData executionInfo(Iterable<SequenceEvent> events) {
        for (SequenceEvent sequenceEvent : events) {
            this.eventTs = Instant.ofEpochMilli(sequenceEvent.timestamp());
            sequenceEvent.event().accept(this.visitor);
        }
        if (!this.completed) {
            this.closeTrigger();
        }
        return WorkflowInstanceExecutionData.create(this.currWorkflowInstance, this.triggerList);
    }

    private class Reducer
    implements EventVisitor<Void> {
        private Reducer() {
        }

        @Override
        public Void timeTrigger(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = false;
            WFIExecutionBuilder.this.currTriggerId = "UNKNOWN";
            WFIExecutionBuilder.this.triggerTs = WFIExecutionBuilder.this.eventTs;
            return null;
        }

        @Override
        public Void triggerExecution(WorkflowInstance workflowInstance, com.spotify.styx.state.Trigger trigger) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = false;
            WFIExecutionBuilder.this.currTriggerId = TriggerUtil.triggerId(trigger);
            WFIExecutionBuilder.this.triggerTs = WFIExecutionBuilder.this.eventTs;
            return null;
        }

        @Override
        public Void info(WorkflowInstance workflowInstance, Message message) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            return null;
        }

        @Override
        public Void dequeue(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            return null;
        }

        @Override
        public Void created(WorkflowInstance workflowInstance, String executionId, String dockerImage) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.currExecutionId = executionId;
            WFIExecutionBuilder.this.currDockerImg = dockerImage;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, "SUBMITTED"));
            return null;
        }

        @Override
        public Void submit(WorkflowInstance workflowInstance, ExecutionDescription executionDescription) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.currDockerImg = executionDescription.dockerImage();
            return null;
        }

        @Override
        public Void submitted(WorkflowInstance workflowInstance, String executionId) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.currExecutionId = executionId;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, "SUBMITTED"));
            return null;
        }

        @Override
        public Void started(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, "STARTED"));
            return null;
        }

        @Override
        public Void terminate(WorkflowInstance workflowInstance, int exitCode) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            String status = exitCode == 0 ? "SUCCESS" : (exitCode == 20 ? "MISSING_DEPS" : "FAILED");
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, status));
            WFIExecutionBuilder.this.closeExecution();
            return null;
        }

        @Override
        public Void runError(WorkflowInstance workflowInstance, String message) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, message));
            WFIExecutionBuilder.this.closeExecution();
            return null;
        }

        @Override
        public Void success(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = true;
            WFIExecutionBuilder.this.closeTrigger();
            return null;
        }

        @Override
        public Void retryAfter(WorkflowInstance workflowInstance, long delayMillis) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            return null;
        }

        @Override
        public Void retry(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            return null;
        }

        @Override
        public Void stop(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = true;
            WFIExecutionBuilder.this.closeTrigger();
            return null;
        }

        @Override
        public Void timeout(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, "TIMEOUT"));
            WFIExecutionBuilder.this.closeExecution();
            return null;
        }

        @Override
        public Void halt(WorkflowInstance workflowInstance) {
            WFIExecutionBuilder.this.currWorkflowInstance = workflowInstance;
            WFIExecutionBuilder.this.completed = true;
            WFIExecutionBuilder.this.executionStatusList.add(ExecStatus.create(WFIExecutionBuilder.this.eventTs, "HALTED"));
            WFIExecutionBuilder.this.closeTrigger();
            return null;
        }
    }
}

