/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.state;

import com.spotify.styx.state.Message;
import io.norberg.automatter.AutoMatter;

public final class MessageBuilder {
    private Message.MessageLevel level;
    private String line;

    public MessageBuilder() {
    }

    private MessageBuilder(Message v) {
        this.level = v.level();
        this.line = v.line();
    }

    private MessageBuilder(MessageBuilder v) {
        this.level = v.level;
        this.line = v.line;
    }

    public Message.MessageLevel level() {
        return this.level;
    }

    public MessageBuilder level(Message.MessageLevel level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        this.level = level;
        return this;
    }

    public String line() {
        return this.line;
    }

    public MessageBuilder line(String line) {
        if (line == null) {
            throw new NullPointerException("line");
        }
        this.line = line;
        return this;
    }

    public Message build() {
        return new Value(this.level, this.line);
    }

    public static MessageBuilder from(Message v) {
        return new MessageBuilder(v);
    }

    public static MessageBuilder from(MessageBuilder v) {
        return new MessageBuilder(v);
    }

    private static final class Value
    implements Message {
        private final Message.MessageLevel level;
        private final String line;

        private Value(@AutoMatter.Field(value="level") Message.MessageLevel level, @AutoMatter.Field(value="line") String line) {
            if (level == null) {
                throw new NullPointerException("level");
            }
            if (line == null) {
                throw new NullPointerException("line");
            }
            this.level = level;
            this.line = line;
        }

        @Override
        @AutoMatter.Field
        public Message.MessageLevel level() {
            return this.level;
        }

        @Override
        @AutoMatter.Field
        public String line() {
            return this.line;
        }

        public MessageBuilder builder() {
            return new MessageBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message that = (Message)o;
            if (this.level != null ? !this.level.equals((Object)that.level()) : that.level() != null) {
                return false;
            }
            return !(this.line != null ? !this.line.equals(that.line()) : that.line() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Message{level=" + (Object)((Object)this.level) + ", line=" + this.line + '}';
        }
    }
}

