/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.storage;

import com.google.cloud.datastore.Datastore;
import com.spotify.styx.model.Backfill;
import com.spotify.styx.model.Resource;
import com.spotify.styx.model.SequenceEvent;
import com.spotify.styx.model.Workflow;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.model.WorkflowState;
import com.spotify.styx.model.data.WorkflowInstanceExecutionData;
import com.spotify.styx.storage.BigtableStorage;
import com.spotify.styx.storage.DatastoreStorage;
import com.spotify.styx.storage.Storage;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.hbase.client.Connection;

public class AggregateStorage
implements Storage {
    private final BigtableStorage bigtableStorage;
    private final DatastoreStorage datastoreStorage;

    public AggregateStorage(Connection connection, Datastore datastore, Duration retryBaseDelay) {
        this.bigtableStorage = new BigtableStorage(connection, retryBaseDelay);
        this.datastoreStorage = new DatastoreStorage(datastore, retryBaseDelay);
    }

    @Override
    public SortedSet<SequenceEvent> readEvents(WorkflowInstance workflowInstance) throws IOException {
        return this.bigtableStorage.readEvents(workflowInstance);
    }

    @Override
    public void writeEvent(SequenceEvent sequenceEvent) throws IOException {
        this.bigtableStorage.writeEvent(sequenceEvent);
    }

    @Override
    public Optional<Long> getLatestStoredCounter(WorkflowInstance workflowInstance) throws IOException {
        return this.bigtableStorage.getLatestStoredCounter(workflowInstance);
    }

    @Override
    public Map<WorkflowInstance, Long> readActiveWorkflowInstances() throws IOException {
        return this.datastoreStorage.allActiveStates();
    }

    @Override
    public Map<WorkflowInstance, Long> readActiveWorkflowInstances(String componentId) throws IOException {
        return this.datastoreStorage.activeStates(componentId);
    }

    @Override
    public void writeActiveState(WorkflowInstance workflowInstance, long counter) throws IOException {
        this.datastoreStorage.writeActiveState(workflowInstance, counter);
    }

    @Override
    public void deleteActiveState(WorkflowInstance workflowInstance) throws IOException {
        this.datastoreStorage.deleteActiveState(workflowInstance);
    }

    @Override
    public boolean globalEnabled() throws IOException {
        return this.datastoreStorage.globalEnabled();
    }

    @Override
    public boolean debugEnabled() throws IOException {
        return this.datastoreStorage.debugEnabled();
    }

    @Override
    public boolean setGlobalEnabled(boolean enabled) throws IOException {
        return this.datastoreStorage.setGlobalEnabled(enabled);
    }

    @Override
    public String globalDockerRunnerId() throws IOException {
        return this.datastoreStorage.globalDockerRunnerId();
    }

    @Override
    public boolean enabled(WorkflowId workflowId) throws IOException {
        return this.datastoreStorage.enabled(workflowId);
    }

    @Override
    public Set<WorkflowId> enabled() throws IOException {
        return this.datastoreStorage.enabled();
    }

    @Override
    public WorkflowInstanceExecutionData executionData(WorkflowInstance workflowInstance) throws IOException {
        return this.bigtableStorage.executionData(workflowInstance);
    }

    @Override
    public List<WorkflowInstanceExecutionData> executionData(WorkflowId workflowId, String offset, int limit) throws IOException {
        return this.bigtableStorage.executionData(workflowId, offset, limit);
    }

    @Override
    public void storeWorkflow(Workflow workflow) throws IOException {
        this.datastoreStorage.store(workflow);
    }

    @Override
    public Optional<Workflow> workflow(WorkflowId workflowId) throws IOException {
        return this.datastoreStorage.workflow(workflowId);
    }

    @Override
    public void delete(WorkflowId workflowId) throws IOException {
        this.datastoreStorage.delete(workflowId);
    }

    @Override
    public void updateNextNaturalTrigger(WorkflowId workflowId, Instant nextNaturalTrigger) throws IOException {
        this.datastoreStorage.updateNextNaturalTrigger(workflowId, nextNaturalTrigger);
    }

    @Override
    public Map<Workflow, Optional<Instant>> workflowsWithNextNaturalTrigger() throws IOException {
        return this.datastoreStorage.workflowsWithNextNaturalTrigger();
    }

    @Override
    public void patchState(WorkflowId workflowId, WorkflowState state) throws IOException {
        this.datastoreStorage.patchState(workflowId, state);
    }

    @Override
    public void patchState(String componentId, WorkflowState state) throws IOException {
        this.datastoreStorage.patchState(componentId, state);
    }

    @Override
    public Optional<String> getDockerImage(WorkflowId workflowId) throws IOException {
        return this.datastoreStorage.getDockerImage(workflowId);
    }

    @Override
    public WorkflowState workflowState(WorkflowId workflowId) throws IOException {
        return this.datastoreStorage.workflowState(workflowId);
    }

    @Override
    public Optional<Resource> resource(String id) throws IOException {
        return this.datastoreStorage.getResource(id);
    }

    @Override
    public List<Resource> resources() throws IOException {
        return this.datastoreStorage.getResources();
    }

    @Override
    public void deleteResource(String id) throws IOException {
        this.datastoreStorage.deleteResource(id);
    }

    @Override
    public void storeBackfill(Backfill backfill) throws IOException {
        this.datastoreStorage.storeBackfill(backfill);
    }

    @Override
    public void storeResource(Resource resource) throws IOException {
        this.datastoreStorage.postResource(resource);
    }

    @Override
    public List<Backfill> backfills() throws IOException {
        return this.datastoreStorage.getBackfills();
    }

    @Override
    public Optional<Backfill> backfill(String id) throws IOException {
        return this.datastoreStorage.getBackfill(id);
    }
}

