/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.testdata;

import com.spotify.styx.model.DataEndpoint;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.Partitioning;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;

public final class TestData {
    public static final URI WORKFLOW_URI = URI.create("http://example.com/foo/bar");
    public static final WorkflowId WORKFLOW_ID = WorkflowId.create("styx", "styx.TestEndpoint");
    public static final WorkflowId WORKFLOW_ID_2 = WorkflowId.create("ranic", "ranic");
    public static final WorkflowInstance WORKFLOW_INSTANCE = WorkflowInstance.create(WORKFLOW_ID, "2016-09-01");
    public static final DataEndpoint HOURLY_DATA_ENDPOINT = DataEndpoint.create("styx.TestEndpoint", Partitioning.HOURS, Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    public static final DataEndpoint DAILY_DATA_ENDPOINT = DataEndpoint.create("styx.TestEndpoint", Partitioning.DAYS, Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    public static final DataEndpoint WEEKLY_DATA_ENDPOINT = DataEndpoint.create("styx.TestEndpoint", Partitioning.WEEKS, Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    public static final DataEndpoint MONTHLY_DATA_ENDPOINT = DataEndpoint.create("styx.TestEndpoint", Partitioning.MONTHS, Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    public static final DataEndpoint FULL_DATA_ENDPOINT = DataEndpoint.create("styx.TestEndpoint", Partitioning.DAYS, Optional.of("busybox"), Optional.of(Arrays.asList("x", "y")), Optional.of(DataEndpoint.Secret.create("name", "/path")), Collections.emptyList());
    public static final ExecutionDescription EXECUTION_DESCRIPTION = ExecutionDescription.create("busybox:1.1", Arrays.asList("foo", "bar"), Optional.of(DataEndpoint.Secret.create("secret", "/dev/null")), Optional.of("00000ef508c1cb905e360590ce3e7e9193f6b370"));

    private TestData() {
    }
}

