/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.common.collect.Lists;
import com.spotify.styx.model.Partitioning;
import com.spotify.styx.model.WorkflowInstance;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import javaslang.control.Either;

public final class ParameterUtil {
    public static final String HOUR_PATTERN = "yyyy-MM-dd'T'HH";
    public static final String DAY_PATTERN = "yyyy-MM-dd";
    private static final int MIN_YEAR_WIDTH = 4;
    private static final int MAX_YEAR_WIDTH = 10;
    private static final DateTimeFormatter ISO_LOCAL_MONTH = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();
    private static final DateTimeFormatter ISO_LOCAL_DATE_HOUR = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).toFormatter();

    private ParameterUtil() {
    }

    public static String formatDateTime(Instant instant) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(instant.atOffset(ZoneOffset.UTC));
    }

    public static String formatDate(Instant instant) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(instant.atOffset(ZoneOffset.UTC));
    }

    public static String formatDateHour(Instant instant) {
        return ISO_LOCAL_DATE_HOUR.format(instant.truncatedTo(ChronoUnit.HOURS).atOffset(ZoneOffset.UTC));
    }

    public static String formatMonth(Instant instant) {
        return ISO_LOCAL_MONTH.format(instant.truncatedTo(ChronoUnit.DAYS).atOffset(ZoneOffset.UTC));
    }

    public static Instant parseDate(String date) {
        return Instant.from(LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(date)).atStartOfDay(ZoneOffset.UTC));
    }

    public static Instant parseDateHour(String dateHour) {
        return Instant.from(ISO_LOCAL_DATE_HOUR.parse(dateHour));
    }

    public static String toParameter(Partitioning partitioning, Instant instant) {
        switch (partitioning) {
            case DAYS: 
            case WEEKS: {
                return ParameterUtil.formatDate(instant);
            }
            case HOURS: {
                return ParameterUtil.formatDateHour(instant);
            }
            case MONTHS: {
                return ParameterUtil.formatMonth(instant);
            }
        }
        throw new IllegalArgumentException("Unknown partitioning " + (Object)((Object)partitioning));
    }

    public static Instant decrementInstant(Instant instant, Partitioning partitioning) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.of(ZoneOffset.UTC.toString()));
        dateTime = dateTime.minus(1L, ParameterUtil.partitioningToTemporalUnit(partitioning));
        Instant updatedInstant = dateTime.atZone(ZoneId.of(ZoneOffset.UTC.toString())).toInstant();
        return updatedInstant;
    }

    public static Instant incrementInstant(Instant instant, Partitioning partitioning) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneId.of(ZoneOffset.UTC.toString()));
        dateTime = dateTime.plus(1L, ParameterUtil.partitioningToTemporalUnit(partitioning));
        Instant updatedInstant = dateTime.atZone(ZoneId.of(ZoneOffset.UTC.toString())).toInstant();
        return updatedInstant;
    }

    public static TemporalUnit partitioningToTemporalUnit(Partitioning partitioning) {
        switch (partitioning) {
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
            case WEEKS: {
                return ChronoUnit.WEEKS;
            }
            case MONTHS: {
                return ChronoUnit.MONTHS;
            }
        }
        throw new IllegalArgumentException("Partitioning not supported: " + (Object)((Object)partitioning));
    }

    public static Instant truncateInstant(Instant instant, Partitioning partitioning) {
        switch (partitioning) {
            case HOURS: {
                return instant.truncatedTo(ChronoUnit.HOURS);
            }
            case DAYS: {
                return instant.truncatedTo(ChronoUnit.DAYS);
            }
            case WEEKS: {
                LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
                int daysToSubtract = dateTime.getDayOfWeek().getValue();
                dateTime = dateTime.minusDays(daysToSubtract - 1);
                Instant resultInstant = dateTime.toInstant(ZoneOffset.UTC);
                return resultInstant.truncatedTo(ChronoUnit.DAYS);
            }
            case MONTHS: {
                ZonedDateTime truncatedToMonth = instant.atZone(ZoneOffset.UTC).truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
                return truncatedToMonth.toInstant();
            }
        }
        throw new IllegalArgumentException("Partitioning not supported: " + (Object)((Object)partitioning));
    }

    public static List<Instant> rangeOfInstants(Instant startInstant, Instant endInstant, Partitioning partitioning) {
        if (endInstant.isBefore(startInstant)) {
            throw new IllegalArgumentException("End time cannot be earlier the start time");
        }
        ArrayList listOfInstants = Lists.newArrayList();
        Instant instantToProcess = startInstant;
        while (instantToProcess.isBefore(endInstant)) {
            listOfInstants.add(instantToProcess);
            instantToProcess = ParameterUtil.incrementInstant(instantToProcess, partitioning);
        }
        return listOfInstants;
    }

    public static Either<String, Instant> instantFromWorkflowInstance(WorkflowInstance workflowInstance, Partitioning partitioning) {
        switch (partitioning) {
            case HOURS: {
                try {
                    LocalDateTime localDateTime = LocalDateTime.parse(workflowInstance.parameter(), DateTimeFormatter.ofPattern(HOUR_PATTERN));
                    return Either.right((Object)localDateTime.toInstant(ZoneOffset.UTC));
                }
                catch (DateTimeParseException e) {
                    return Either.left((Object)ParameterUtil.parseErrorMessage(partitioning, HOUR_PATTERN));
                }
            }
            case DAYS: {
                try {
                    LocalDate localDate = LocalDate.parse(workflowInstance.parameter(), DateTimeFormatter.ofPattern(DAY_PATTERN));
                    return Either.right((Object)localDate.atStartOfDay().toInstant(ZoneOffset.UTC));
                }
                catch (DateTimeParseException e) {
                    return Either.left((Object)ParameterUtil.parseErrorMessage(partitioning, DAY_PATTERN));
                }
            }
            case WEEKS: {
                try {
                    LocalDate localDate = LocalDate.parse(workflowInstance.parameter(), DateTimeFormatter.ofPattern(DAY_PATTERN));
                    int daysToSubtract = localDate.getDayOfWeek().getValue();
                    localDate = localDate.minusDays(daysToSubtract - 1);
                    return Either.right((Object)localDate.atStartOfDay().toInstant(ZoneOffset.UTC));
                }
                catch (DateTimeParseException e) {
                    return Either.left((Object)ParameterUtil.parseErrorMessage(partitioning, DAY_PATTERN));
                }
            }
        }
        return Either.left((Object)("Partitioning not supported: " + (Object)((Object)partitioning)));
    }

    private static String parseErrorMessage(Partitioning partitioning, String pattern) {
        return String.format("Cannot parse time parameter. Expected partitioning is %s: %s", new Object[]{partitioning, pattern});
    }
}

