/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.spotify.styx.state.Trigger;
import com.spotify.styx.state.TriggerVisitor;

public class TriggerUtil {
    public static final String NATURAL_TRIGGER_ID = "natural-trigger";

    private TriggerUtil() {
    }

    public static boolean isBackfill(Trigger trigger) {
        return trigger.accept(TriggerIsBackfillVisitor.INSTANCE);
    }

    public static String name(Trigger trigger) {
        return trigger.accept(TriggerNameVisitor.INSTANCE);
    }

    public static String triggerId(Trigger trigger) {
        return trigger.accept(TriggerIdVisitor.INSTANCE);
    }

    private static enum TriggerIdVisitor implements TriggerVisitor<String>
    {
        INSTANCE;


        @Override
        public String natural() {
            return TriggerUtil.NATURAL_TRIGGER_ID;
        }

        @Override
        public String adhoc(String triggerId) {
            return triggerId;
        }

        @Override
        public String backfill(String triggerId) {
            return triggerId;
        }

        @Override
        public String unknown(String triggerId) {
            return triggerId;
        }
    }

    private static enum TriggerNameVisitor implements TriggerVisitor<String>
    {
        INSTANCE;


        @Override
        public String natural() {
            return "natural";
        }

        @Override
        public String adhoc(String triggerId) {
            return "adhoc";
        }

        @Override
        public String backfill(String triggerId) {
            return "backfill";
        }

        @Override
        public String unknown(String triggerId) {
            return "unknown";
        }
    }

    private static enum TriggerIsBackfillVisitor implements TriggerVisitor<Boolean>
    {
        INSTANCE;


        @Override
        public Boolean natural() {
            return false;
        }

        @Override
        public Boolean adhoc(String triggerId) {
            return false;
        }

        @Override
        public Boolean backfill(String triggerId) {
            return true;
        }

        @Override
        public Boolean unknown(String triggerId) {
            return false;
        }
    }
}

