package com.spotify.styx.api;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class AuthContextBuilder {
  private Optional<GoogleIdToken> user;

  public AuthContextBuilder() {
    this.user = Optional.empty();
  }

  private AuthContextBuilder(Middlewares.AuthContext v) {
    this.user = v.user();
  }

  private AuthContextBuilder(AuthContextBuilder v) {
    this.user = v.user;
  }

  public Optional<GoogleIdToken> user() {
    return user;
  }

  public AuthContextBuilder user(GoogleIdToken user) {
    return user(Optional.ofNullable(user));
  }

  @SuppressWarnings("unchecked")
  public AuthContextBuilder user(Optional<? extends GoogleIdToken> user) {
    if (user == null) {
      throw new NullPointerException("user");
    }
    this.user = (Optional<GoogleIdToken>)user;
    return this;
  }

  public Middlewares.AuthContext build() {
    return new Value(user);
  }

  public static AuthContextBuilder from(Middlewares.AuthContext v) {
    return new AuthContextBuilder(v);
  }

  public static AuthContextBuilder from(AuthContextBuilder v) {
    return new AuthContextBuilder(v);
  }

  private static final class Value implements Middlewares.AuthContext {
    private final Optional<GoogleIdToken> user;

    private Value(@AutoMatter.Field("user") Optional<GoogleIdToken> user) {
      if (user == null) {
        throw new NullPointerException("user");
      }
      this.user = user;
    }

    @AutoMatter.Field
    @Override
    public Optional<GoogleIdToken> user() {
      return user;
    }

    public AuthContextBuilder builder() {
      return new AuthContextBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Middlewares.AuthContext)) {
        return false;
      }
      final Middlewares.AuthContext that = (Middlewares.AuthContext) o;
      if (user != null ? !user.equals(that.user()) : that.user() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "Middlewares.AuthContext{" +
      "user=" + user +
      '}';
    }
  }
}
