package com.spotify.styx.serialization;

import com.spotify.styx.state.RunState;
import com.spotify.styx.state.StateData;
import io.norberg.automatter.AutoMatter;
import java.time.Instant;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class PersistentWorkflowInstanceStateBuilder {
  private long counter;

  private Instant timestamp;

  private RunState.State state;

  private StateData data;

  public PersistentWorkflowInstanceStateBuilder() {
  }

  private PersistentWorkflowInstanceStateBuilder(PersistentWorkflowInstanceState v) {
    this.counter = v.counter();
    this.timestamp = v.timestamp();
    this.state = v.state();
    this.data = v.data();
  }

  private PersistentWorkflowInstanceStateBuilder(PersistentWorkflowInstanceStateBuilder v) {
    this.counter = v.counter;
    this.timestamp = v.timestamp;
    this.state = v.state;
    this.data = v.data;
  }

  public long counter() {
    return counter;
  }

  public PersistentWorkflowInstanceStateBuilder counter(long counter) {
    this.counter = counter;
    return this;
  }

  public Instant timestamp() {
    return timestamp;
  }

  public PersistentWorkflowInstanceStateBuilder timestamp(@Nullable Instant timestamp) {
    this.timestamp = timestamp;
    return this;
  }

  public RunState.State state() {
    return state;
  }

  public PersistentWorkflowInstanceStateBuilder state(@Nullable RunState.State state) {
    this.state = state;
    return this;
  }

  public StateData data() {
    return data;
  }

  public PersistentWorkflowInstanceStateBuilder data(@Nullable StateData data) {
    this.data = data;
    return this;
  }

  public PersistentWorkflowInstanceState build() {
    return new Value(counter, timestamp, state, data);
  }

  public static PersistentWorkflowInstanceStateBuilder from(PersistentWorkflowInstanceState v) {
    return new PersistentWorkflowInstanceStateBuilder(v);
  }

  public static PersistentWorkflowInstanceStateBuilder from(PersistentWorkflowInstanceStateBuilder v) {
    return new PersistentWorkflowInstanceStateBuilder(v);
  }

  private static final class Value implements PersistentWorkflowInstanceState {
    private final long counter;

    private final Instant timestamp;

    private final RunState.State state;

    private final StateData data;

    private Value(@AutoMatter.Field("counter") long counter, @AutoMatter.Field("timestamp") Instant timestamp, @AutoMatter.Field("state") RunState.State state, @AutoMatter.Field("data") StateData data) {
      this.counter = counter;
      this.timestamp = timestamp;
      this.state = state;
      this.data = data;
    }

    @AutoMatter.Field
    @Override
    public long counter() {
      return counter;
    }

    @AutoMatter.Field
    @Override
    public Instant timestamp() {
      return timestamp;
    }

    @AutoMatter.Field
    @Override
    public RunState.State state() {
      return state;
    }

    @AutoMatter.Field
    @Override
    public StateData data() {
      return data;
    }

    public PersistentWorkflowInstanceStateBuilder builder() {
      return new PersistentWorkflowInstanceStateBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof PersistentWorkflowInstanceState)) {
        return false;
      }
      final PersistentWorkflowInstanceState that = (PersistentWorkflowInstanceState) o;
      if (counter != that.counter()) {
        return false;
      }
      if (timestamp != null ? !timestamp.equals(that.timestamp()) : that.timestamp() != null) {
        return false;
      }
      if (state != null ? !state.equals(that.state()) : that.state() != null) {
        return false;
      }
      if (data != null ? !data.equals(that.data()) : that.data() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (int) (this.counter ^ (this.counter >>> 32));
      result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
      result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
      result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "PersistentWorkflowInstanceState{" +
      "counter=" + counter +
      ", timestamp=" + timestamp +
      ", state=" + state +
      ", data=" + data +
      '}';
    }
  }
}
