
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ExecutionDescription extends ExecutionDescription {

  private final String dockerImage;
  private final List<String> dockerArgs;
  private final boolean dockerTerminationLogging;
  private final Optional<WorkflowConfiguration.Secret> secret;
  private final Optional<String> serviceAccount;
  private final Optional<String> commitSha;

  AutoValue_ExecutionDescription(
      String dockerImage,
      List<String> dockerArgs,
      boolean dockerTerminationLogging,
      Optional<WorkflowConfiguration.Secret> secret,
      Optional<String> serviceAccount,
      Optional<String> commitSha) {
    if (dockerImage == null) {
      throw new NullPointerException("Null dockerImage");
    }
    this.dockerImage = dockerImage;
    if (dockerArgs == null) {
      throw new NullPointerException("Null dockerArgs");
    }
    this.dockerArgs = dockerArgs;
    this.dockerTerminationLogging = dockerTerminationLogging;
    if (secret == null) {
      throw new NullPointerException("Null secret");
    }
    this.secret = secret;
    if (serviceAccount == null) {
      throw new NullPointerException("Null serviceAccount");
    }
    this.serviceAccount = serviceAccount;
    if (commitSha == null) {
      throw new NullPointerException("Null commitSha");
    }
    this.commitSha = commitSha;
  }

  @JsonProperty
  @Override
  public String dockerImage() {
    return dockerImage;
  }

  @JsonProperty
  @Override
  public List<String> dockerArgs() {
    return dockerArgs;
  }

  @JsonProperty
  @Override
  public boolean dockerTerminationLogging() {
    return dockerTerminationLogging;
  }

  @JsonProperty
  @Override
  public Optional<WorkflowConfiguration.Secret> secret() {
    return secret;
  }

  @JsonProperty
  @Override
  public Optional<String> serviceAccount() {
    return serviceAccount;
  }

  @JsonProperty
  @Override
  public Optional<String> commitSha() {
    return commitSha;
  }

  @Override
  public String toString() {
    return "ExecutionDescription{"
        + "dockerImage=" + dockerImage + ", "
        + "dockerArgs=" + dockerArgs + ", "
        + "dockerTerminationLogging=" + dockerTerminationLogging + ", "
        + "secret=" + secret + ", "
        + "serviceAccount=" + serviceAccount + ", "
        + "commitSha=" + commitSha
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExecutionDescription) {
      ExecutionDescription that = (ExecutionDescription) o;
      return (this.dockerImage.equals(that.dockerImage()))
           && (this.dockerArgs.equals(that.dockerArgs()))
           && (this.dockerTerminationLogging == that.dockerTerminationLogging())
           && (this.secret.equals(that.secret()))
           && (this.serviceAccount.equals(that.serviceAccount()))
           && (this.commitSha.equals(that.commitSha()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.dockerImage.hashCode();
    h *= 1000003;
    h ^= this.dockerArgs.hashCode();
    h *= 1000003;
    h ^= this.dockerTerminationLogging ? 1231 : 1237;
    h *= 1000003;
    h ^= this.secret.hashCode();
    h *= 1000003;
    h ^= this.serviceAccount.hashCode();
    h *= 1000003;
    h ^= this.commitSha.hashCode();
    return h;
  }

}
