package com.spotify.styx.model;

import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class WorkflowConfigurationBuilder {
  private String id;

  private Schedule schedule;

  private Optional<String> offset;

  private Optional<String> dockerImage;

  private Optional<List<String>> dockerArgs;

  private boolean dockerTerminationLogging;

  private Optional<WorkflowConfiguration.Secret> secret;

  private Optional<String> serviceAccount;

  private List<String> resources;

  public WorkflowConfigurationBuilder() {
    this.offset = Optional.empty();
    this.dockerImage = Optional.empty();
    this.dockerArgs = Optional.empty();
    this.secret = Optional.empty();
    this.serviceAccount = Optional.empty();
  }

  private WorkflowConfigurationBuilder(WorkflowConfiguration v) {
    this.id = v.id();
    this.schedule = v.schedule();
    this.offset = v.offset();
    this.dockerImage = v.dockerImage();
    this.dockerArgs = v.dockerArgs();
    this.dockerTerminationLogging = v.dockerTerminationLogging();
    this.secret = v.secret();
    this.serviceAccount = v.serviceAccount();
    List<? extends String> _resources = v.resources();
    this.resources = (_resources == null) ? null : new ArrayList<String>(_resources);
  }

  private WorkflowConfigurationBuilder(WorkflowConfigurationBuilder v) {
    this.id = v.id;
    this.schedule = v.schedule;
    this.offset = v.offset;
    this.dockerImage = v.dockerImage;
    this.dockerArgs = v.dockerArgs;
    this.dockerTerminationLogging = v.dockerTerminationLogging;
    this.secret = v.secret;
    this.serviceAccount = v.serviceAccount;
    this.resources = (v.resources == null) ? null : new ArrayList<String>(v.resources);
  }

  public String id() {
    return id;
  }

  public WorkflowConfigurationBuilder id(String id) {
    if (id == null) {
      throw new NullPointerException("id");
    }
    this.id = id;
    return this;
  }

  public Schedule schedule() {
    return schedule;
  }

  public WorkflowConfigurationBuilder schedule(Schedule schedule) {
    if (schedule == null) {
      throw new NullPointerException("schedule");
    }
    this.schedule = schedule;
    return this;
  }

  public Optional<String> offset() {
    return offset;
  }

  public WorkflowConfigurationBuilder offset(String offset) {
    return offset(Optional.ofNullable(offset));
  }

  @SuppressWarnings("unchecked")
  public WorkflowConfigurationBuilder offset(Optional<? extends String> offset) {
    if (offset == null) {
      throw new NullPointerException("offset");
    }
    this.offset = (Optional<String>)offset;
    return this;
  }

  public Optional<String> dockerImage() {
    return dockerImage;
  }

  public WorkflowConfigurationBuilder dockerImage(String dockerImage) {
    return dockerImage(Optional.ofNullable(dockerImage));
  }

  @SuppressWarnings("unchecked")
  public WorkflowConfigurationBuilder dockerImage(Optional<? extends String> dockerImage) {
    if (dockerImage == null) {
      throw new NullPointerException("dockerImage");
    }
    this.dockerImage = (Optional<String>)dockerImage;
    return this;
  }

  public Optional<List<String>> dockerArgs() {
    return dockerArgs;
  }

  public WorkflowConfigurationBuilder dockerArgs(List<String> dockerArgs) {
    return dockerArgs(Optional.ofNullable(dockerArgs));
  }

  @SuppressWarnings("unchecked")
  public WorkflowConfigurationBuilder dockerArgs(Optional<? extends List<String>> dockerArgs) {
    if (dockerArgs == null) {
      throw new NullPointerException("dockerArgs");
    }
    this.dockerArgs = (Optional<List<String>>)dockerArgs;
    return this;
  }

  public boolean dockerTerminationLogging() {
    return dockerTerminationLogging;
  }

  public WorkflowConfigurationBuilder dockerTerminationLogging(boolean dockerTerminationLogging) {
    this.dockerTerminationLogging = dockerTerminationLogging;
    return this;
  }

  public Optional<WorkflowConfiguration.Secret> secret() {
    return secret;
  }

  public WorkflowConfigurationBuilder secret(WorkflowConfiguration.Secret secret) {
    return secret(Optional.ofNullable(secret));
  }

  @SuppressWarnings("unchecked")
  public WorkflowConfigurationBuilder secret(Optional<? extends WorkflowConfiguration.Secret> secret) {
    if (secret == null) {
      throw new NullPointerException("secret");
    }
    this.secret = (Optional<WorkflowConfiguration.Secret>)secret;
    return this;
  }

  public Optional<String> serviceAccount() {
    return serviceAccount;
  }

  public WorkflowConfigurationBuilder serviceAccount(String serviceAccount) {
    return serviceAccount(Optional.ofNullable(serviceAccount));
  }

  @SuppressWarnings("unchecked")
  public WorkflowConfigurationBuilder serviceAccount(Optional<? extends String> serviceAccount) {
    if (serviceAccount == null) {
      throw new NullPointerException("serviceAccount");
    }
    this.serviceAccount = (Optional<String>)serviceAccount;
    return this;
  }

  public List<String> resources() {
    if (this.resources == null) {
      this.resources = new ArrayList<String>();
    }
    return resources;
  }

  public WorkflowConfigurationBuilder resources(List<? extends String> resources) {
    return resources((Collection<? extends String>) resources);
  }

  public WorkflowConfigurationBuilder resources(Collection<? extends String> resources) {
    if (resources == null) {
      throw new NullPointerException("resources");
    }
    for (String item : resources) {
      if (item == null) {
        throw new NullPointerException("resources: null item");
      }
    }
    this.resources = new ArrayList<String>(resources);
    return this;
  }

  public WorkflowConfigurationBuilder resources(Iterable<? extends String> resources) {
    if (resources == null) {
      throw new NullPointerException("resources");
    }
    if (resources instanceof Collection) {
      return resources((Collection<? extends String>) resources);
    }
    return resources(resources.iterator());
  }

  public WorkflowConfigurationBuilder resources(Iterator<? extends String> resources) {
    if (resources == null) {
      throw new NullPointerException("resources");
    }
    this.resources = new ArrayList<String>();
    while (resources.hasNext()) {
      String item = resources.next();
      if (item == null) {
        throw new NullPointerException("resources: null item");
      }
      this.resources.add(item);
    }
    return this;
  }

  @SafeVarargs
  public final WorkflowConfigurationBuilder resources(String... resources) {
    if (resources == null) {
      throw new NullPointerException("resources");
    }
    return resources(Arrays.asList(resources));
  }

  public WorkflowConfigurationBuilder addResource(String resource) {
    if (resource == null) {
      throw new NullPointerException("resource");
    }
    if (this.resources == null) {
      this.resources = new ArrayList<String>();
    }
    resources.add(resource);
    return this;
  }

  public WorkflowConfiguration build() {
    List<String> _resources = (resources != null) ? Collections.unmodifiableList(new ArrayList<String>(resources)) : Collections.<String>emptyList();
    return new Value(id, schedule, offset, dockerImage, dockerArgs, dockerTerminationLogging, secret, serviceAccount, _resources);
  }

  public static WorkflowConfigurationBuilder from(WorkflowConfiguration v) {
    return new WorkflowConfigurationBuilder(v);
  }

  public static WorkflowConfigurationBuilder from(WorkflowConfigurationBuilder v) {
    return new WorkflowConfigurationBuilder(v);
  }

  private static final class Value implements WorkflowConfiguration {
    private final String id;

    private final Schedule schedule;

    private final Optional<String> offset;

    private final Optional<String> dockerImage;

    private final Optional<List<String>> dockerArgs;

    private final boolean dockerTerminationLogging;

    private final Optional<WorkflowConfiguration.Secret> secret;

    private final Optional<String> serviceAccount;

    private final List<String> resources;

    private Value(@AutoMatter.Field("id") String id, @AutoMatter.Field("schedule") Schedule schedule, @AutoMatter.Field("offset") Optional<String> offset, @AutoMatter.Field("dockerImage") Optional<String> dockerImage, @AutoMatter.Field("dockerArgs") Optional<List<String>> dockerArgs, @AutoMatter.Field("dockerTerminationLogging") boolean dockerTerminationLogging, @AutoMatter.Field("secret") Optional<WorkflowConfiguration.Secret> secret, @AutoMatter.Field("serviceAccount") Optional<String> serviceAccount, @AutoMatter.Field("resources") List<String> resources) {
      if (id == null) {
        throw new NullPointerException("id");
      }
      if (schedule == null) {
        throw new NullPointerException("schedule");
      }
      if (offset == null) {
        throw new NullPointerException("offset");
      }
      if (dockerImage == null) {
        throw new NullPointerException("dockerImage");
      }
      if (dockerArgs == null) {
        throw new NullPointerException("dockerArgs");
      }
      if (secret == null) {
        throw new NullPointerException("secret");
      }
      if (serviceAccount == null) {
        throw new NullPointerException("serviceAccount");
      }
      this.id = id;
      this.schedule = schedule;
      this.offset = offset;
      this.dockerImage = dockerImage;
      this.dockerArgs = dockerArgs;
      this.dockerTerminationLogging = dockerTerminationLogging;
      this.secret = secret;
      this.serviceAccount = serviceAccount;
      this.resources = (resources != null) ? resources : Collections.<String>emptyList();
    }

    @AutoMatter.Field
    @Override
    public String id() {
      return id;
    }

    @AutoMatter.Field
    @Override
    public Schedule schedule() {
      return schedule;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> offset() {
      return offset;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> dockerImage() {
      return dockerImage;
    }

    @AutoMatter.Field
    @Override
    public Optional<List<String>> dockerArgs() {
      return dockerArgs;
    }

    @AutoMatter.Field
    @Override
    public boolean dockerTerminationLogging() {
      return dockerTerminationLogging;
    }

    @AutoMatter.Field
    @Override
    public Optional<WorkflowConfiguration.Secret> secret() {
      return secret;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> serviceAccount() {
      return serviceAccount;
    }

    @AutoMatter.Field
    @Override
    public List<String> resources() {
      return resources;
    }

    public WorkflowConfigurationBuilder builder() {
      return new WorkflowConfigurationBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof WorkflowConfiguration)) {
        return false;
      }
      final WorkflowConfiguration that = (WorkflowConfiguration) o;
      if (id != null ? !id.equals(that.id()) : that.id() != null) {
        return false;
      }
      if (schedule != null ? !schedule.equals(that.schedule()) : that.schedule() != null) {
        return false;
      }
      if (offset != null ? !offset.equals(that.offset()) : that.offset() != null) {
        return false;
      }
      if (dockerImage != null ? !dockerImage.equals(that.dockerImage()) : that.dockerImage() != null) {
        return false;
      }
      if (dockerArgs != null ? !dockerArgs.equals(that.dockerArgs()) : that.dockerArgs() != null) {
        return false;
      }
      if (dockerTerminationLogging != that.dockerTerminationLogging()) {
        return false;
      }
      if (secret != null ? !secret.equals(that.secret()) : that.secret() != null) {
        return false;
      }
      if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount()) : that.serviceAccount() != null) {
        return false;
      }
      if (resources != null ? !resources.equals(that.resources()) : that.resources() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (id != null ? id.hashCode() : 0);
      result = 31 * result + (schedule != null ? schedule.hashCode() : 0);
      result = 31 * result + (offset != null ? offset.hashCode() : 0);
      result = 31 * result + (dockerImage != null ? dockerImage.hashCode() : 0);
      result = 31 * result + (dockerArgs != null ? dockerArgs.hashCode() : 0);
      result = 31 * result + (dockerTerminationLogging ? 1231 : 1237);
      result = 31 * result + (secret != null ? secret.hashCode() : 0);
      result = 31 * result + (serviceAccount != null ? serviceAccount.hashCode() : 0);
      result = 31 * result + (resources != null ? resources.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "WorkflowConfiguration{" +
      "id=" + id +
      ", schedule=" + schedule +
      ", offset=" + offset +
      ", dockerImage=" + dockerImage +
      ", dockerArgs=" + dockerArgs +
      ", dockerTerminationLogging=" + dockerTerminationLogging +
      ", secret=" + secret +
      ", serviceAccount=" + serviceAccount +
      ", resources=" + resources +
      '}';
    }
  }
}
