
package com.spotify.styx.state;

import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.util.Time;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_RunState extends RunState {

  private final WorkflowInstance workflowInstance;
  private final RunState.State state;
  private final long timestamp;
  private final StateData data;
  private final Time time;
  private final OutputHandler outputHandler;

  AutoValue_RunState(
      WorkflowInstance workflowInstance,
      RunState.State state,
      long timestamp,
      StateData data,
      Time time,
      OutputHandler outputHandler) {
    if (workflowInstance == null) {
      throw new NullPointerException("Null workflowInstance");
    }
    this.workflowInstance = workflowInstance;
    if (state == null) {
      throw new NullPointerException("Null state");
    }
    this.state = state;
    this.timestamp = timestamp;
    if (data == null) {
      throw new NullPointerException("Null data");
    }
    this.data = data;
    if (time == null) {
      throw new NullPointerException("Null time");
    }
    this.time = time;
    if (outputHandler == null) {
      throw new NullPointerException("Null outputHandler");
    }
    this.outputHandler = outputHandler;
  }

  @Override
  public WorkflowInstance workflowInstance() {
    return workflowInstance;
  }

  @Override
  public RunState.State state() {
    return state;
  }

  @Override
  public long timestamp() {
    return timestamp;
  }

  @Override
  public StateData data() {
    return data;
  }

  @Override
  Time time() {
    return time;
  }

  @Override
  OutputHandler outputHandler() {
    return outputHandler;
  }

  @Override
  public String toString() {
    return "RunState{"
        + "workflowInstance=" + workflowInstance + ", "
        + "state=" + state + ", "
        + "timestamp=" + timestamp + ", "
        + "data=" + data + ", "
        + "time=" + time + ", "
        + "outputHandler=" + outputHandler
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RunState) {
      RunState that = (RunState) o;
      return (this.workflowInstance.equals(that.workflowInstance()))
           && (this.state.equals(that.state()))
           && (this.timestamp == that.timestamp())
           && (this.data.equals(that.data()))
           && (this.time.equals(that.time()))
           && (this.outputHandler.equals(that.outputHandler()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.workflowInstance.hashCode();
    h *= 1000003;
    h ^= this.state.hashCode();
    h *= 1000003;
    h ^= (this.timestamp >>> 32) ^ this.timestamp;
    h *= 1000003;
    h ^= this.data.hashCode();
    h *= 1000003;
    h ^= this.time.hashCode();
    h *= 1000003;
    h ^= this.outputHandler.hashCode();
    return h;
  }

}
