package com.spotify.styx.state;

import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Generated("com.github.sviperll.adt4j.GenerateValueClassForVisitorProcessor")
@ParametersAreNonnullByDefault
public class Trigger {
    private final TriggerAcceptor acceptor;
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static Trigger NATURAL = new Trigger(new NaturalCaseTriggerAcceptor());
    @SuppressWarnings({
        "unchecked",
        "rawtypes"
    })
    private final static TriggerFactory FACTORY = new TriggerFactory();

    private Trigger(TriggerAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    @SuppressWarnings({
        "null"
    })
    protected Trigger(
        @Nonnull
        Trigger implementation) {
        if (implementation == null) {
            throw new NullPointerException("Argument shouldn't be null: 'implementation' argument in class constructor invocation: com.spotify.styx.state.Trigger");
        }
        this.acceptor = implementation.acceptor;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static Trigger adhoc(
        @Nonnull
        String triggerId) {
        if (triggerId == null) {
            throw new NullPointerException("Argument shouldn't be null: 'triggerId' argument in static method invocation: 'adhoc' in class com.spotify.styx.state.Trigger");
        }
        return new Trigger(new AdhocCaseTriggerAcceptor(triggerId));
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static Trigger backfill(
        @Nonnull
        String triggerId) {
        if (triggerId == null) {
            throw new NullPointerException("Argument shouldn't be null: 'triggerId' argument in static method invocation: 'backfill' in class com.spotify.styx.state.Trigger");
        }
        return new Trigger(new BackfillCaseTriggerAcceptor(triggerId));
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static Trigger natural() {
        return NATURAL;
    }

    @Nonnull
    @SuppressWarnings({
        "null"
    })
    public static Trigger unknown(
        @Nonnull
        String triggerId) {
        if (triggerId == null) {
            throw new NullPointerException("Argument shouldn't be null: 'triggerId' argument in static method invocation: 'unknown' in class com.spotify.styx.state.Trigger");
        }
        return new Trigger(new UnknownCaseTriggerAcceptor(triggerId));
    }

    public final<R extends Object> R accept(TriggerVisitor<R> visitor) {
        return acceptor.accept(visitor);
    }

    @Override
    public final boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        } else {
            if (!(thatObject instanceof Trigger)) {
                return false;
            } else {
                Trigger that = ((Trigger) thatObject);
                return this.acceptor.triggerEquals(that.acceptor);
            }
        }
    }

    @Override
    public final int hashCode() {
        return this.acceptor.triggerHashCode();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.acceptor.toString();
    }

    @Nonnull
    @SuppressWarnings("unchecked")
    public static TriggerVisitor<Trigger> factory() {
        return FACTORY;
    }

    private static class AdhocCaseTriggerAcceptor
        implements TriggerAcceptor
    {
        private final String triggerId;

        AdhocCaseTriggerAcceptor(String triggerId) {
            this.triggerId = triggerId;
        }

        @Override
        public<R extends Object> R accept(TriggerVisitor<R> visitor) {
            return visitor.adhoc(this.triggerId);
        }

        @Override
        public final boolean triggerEquals(TriggerAcceptor thatAcceptor) {
            return thatAcceptor.triggerEqualsAdhoc(this.triggerId);
        }

        @Override
        public boolean triggerEqualsAdhoc(String triggerId) {
            return triggerId.equals(this.triggerId);
        }

        @Override
        public boolean triggerEqualsBackfill(String triggerId) {
            return false;
        }

        @Override
        public boolean triggerEqualsNatural() {
            return false;
        }

        @Override
        public boolean triggerEqualsUnknown(String triggerId) {
            return false;
        }

        @Override
        public final int triggerHashCode() {
            int result = 1;
            result = ((result* 37)+ this.triggerId.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Trigger.Adhoc{");
            result.append("triggerId = ");
            result.append(this.triggerId);
            result.append("}");
            return result.toString();
        }
    }

    private static class BackfillCaseTriggerAcceptor
        implements TriggerAcceptor
    {
        private final String triggerId;

        BackfillCaseTriggerAcceptor(String triggerId) {
            this.triggerId = triggerId;
        }

        @Override
        public<R extends Object> R accept(TriggerVisitor<R> visitor) {
            return visitor.backfill(this.triggerId);
        }

        @Override
        public boolean triggerEqualsAdhoc(String triggerId) {
            return false;
        }

        @Override
        public final boolean triggerEquals(TriggerAcceptor thatAcceptor) {
            return thatAcceptor.triggerEqualsBackfill(this.triggerId);
        }

        @Override
        public boolean triggerEqualsBackfill(String triggerId) {
            return triggerId.equals(this.triggerId);
        }

        @Override
        public boolean triggerEqualsNatural() {
            return false;
        }

        @Override
        public boolean triggerEqualsUnknown(String triggerId) {
            return false;
        }

        @Override
        public final int triggerHashCode() {
            int result = 2;
            result = ((result* 37)+ this.triggerId.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Trigger.Backfill{");
            result.append("triggerId = ");
            result.append(this.triggerId);
            result.append("}");
            return result.toString();
        }
    }

    private static class NaturalCaseTriggerAcceptor
        implements TriggerAcceptor
    {

        NaturalCaseTriggerAcceptor() {
        }

        @Override
        public<R extends Object> R accept(TriggerVisitor<R> visitor) {
            return visitor.natural();
        }

        @Override
        public boolean triggerEqualsAdhoc(String triggerId) {
            return false;
        }

        @Override
        public boolean triggerEqualsBackfill(String triggerId) {
            return false;
        }

        @Override
        public final boolean triggerEquals(TriggerAcceptor thatAcceptor) {
            return thatAcceptor.triggerEqualsNatural();
        }

        @Override
        public boolean triggerEqualsNatural() {
            return true;
        }

        @Override
        public boolean triggerEqualsUnknown(String triggerId) {
            return false;
        }

        @Override
        public final int triggerHashCode() {
            int result = 3;
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Trigger.Natural{");
            result.append("}");
            return result.toString();
        }
    }

    private interface TriggerAcceptor {

        public<R extends Object> R accept(TriggerVisitor<R> visitor);

        public boolean triggerEquals(TriggerAcceptor thatAcceptor);

        public boolean triggerEqualsAdhoc(String triggerId);

        public boolean triggerEqualsBackfill(String triggerId);

        public boolean triggerEqualsNatural();

        public boolean triggerEqualsUnknown(String triggerId);

        public int triggerHashCode();
    }

    private static class TriggerFactory
        implements TriggerVisitor<Trigger>
    {

        @Nonnull
        @Override
        public Trigger adhoc(String triggerId) {
            return Trigger.adhoc(triggerId);
        }

        @Nonnull
        @Override
        public Trigger backfill(String triggerId) {
            return Trigger.backfill(triggerId);
        }

        @Nonnull
        @Override
        public Trigger natural() {
            return Trigger.natural();
        }

        @Nonnull
        @Override
        public Trigger unknown(String triggerId) {
            return Trigger.unknown(triggerId);
        }
    }

    private static class UnknownCaseTriggerAcceptor
        implements TriggerAcceptor
    {
        private final String triggerId;

        UnknownCaseTriggerAcceptor(String triggerId) {
            this.triggerId = triggerId;
        }

        @Override
        public<R extends Object> R accept(TriggerVisitor<R> visitor) {
            return visitor.unknown(this.triggerId);
        }

        @Override
        public boolean triggerEqualsAdhoc(String triggerId) {
            return false;
        }

        @Override
        public boolean triggerEqualsBackfill(String triggerId) {
            return false;
        }

        @Override
        public boolean triggerEqualsNatural() {
            return false;
        }

        @Override
        public final boolean triggerEquals(TriggerAcceptor thatAcceptor) {
            return thatAcceptor.triggerEqualsUnknown(this.triggerId);
        }

        @Override
        public boolean triggerEqualsUnknown(String triggerId) {
            return triggerId.equals(this.triggerId);
        }

        @Override
        public final int triggerHashCode() {
            int result = 4;
            result = ((result* 37)+ this.triggerId.hashCode());
            return result;
        }

        @Override
        @Nonnull
        public final String toString() {
            StringBuilder result = new StringBuilder();
            result.append("Trigger.Unknown{");
            result.append("triggerId = ");
            result.append(this.triggerId);
            result.append("}");
            return result.toString();
        }
    }
}
