/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.SecretBuilder;
import com.spotify.styx.model.WorkflowConfigurationBuilder;
import com.spotify.styx.util.TimeUtil;
import io.norberg.automatter.AutoMatter;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Optional;

@AutoMatter
@JsonIgnoreProperties(ignoreUnknown=true)
public interface WorkflowConfiguration {
    public String id();

    public Schedule schedule();

    public Optional<String> offset();

    public Optional<String> dockerImage();

    public Optional<List<String>> dockerArgs();

    public boolean dockerTerminationLogging();

    public Optional<Secret> secret();

    public Optional<String> serviceAccount();

    public List<String> resources();

    default public Instant addOffset(Instant next) {
        String offset = this.offset().orElseGet(this::defaultOffset);
        return TimeUtil.addOffset(next.atZone(ZoneOffset.UTC), offset).toInstant();
    }

    default public String defaultOffset() {
        return this.defaultOffset(this.schedule());
    }

    default public String defaultOffset(Schedule schedule) {
        return this.defaultOffset(schedule.wellKnown());
    }

    default public String defaultOffset(Schedule.WellKnown schedule) {
        switch (schedule) {
            case HOURLY: {
                return "PT1H";
            }
            case DAILY: {
                return "P1D";
            }
            case WEEKLY: {
                return "P1W";
            }
            case MONTHLY: {
                return "P1M";
            }
            case YEARLY: {
                return "P1Y";
            }
        }
        return "PT0S";
    }

    public static WorkflowConfigurationBuilder builder() {
        return new WorkflowConfigurationBuilder();
    }

    @AutoMatter
    public static interface Secret {
        public String name();

        public String mountPath();

        public static Secret create(String name, String mountPath) {
            return Secret.builder().name(name).mountPath(mountPath).build();
        }

        public static SecretBuilder builder() {
            return new SecretBuilder();
        }
    }
}

