/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.state;

import com.spotify.styx.state.OutputHandler;
import com.spotify.styx.state.RunState;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FanOutputHandler
implements OutputHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FanOutputHandler.class);
    private final OutputHandler[] outputHandlers;

    FanOutputHandler(OutputHandler[] outputHandlers) {
        this.outputHandlers = Objects.requireNonNull(outputHandlers);
    }

    @Override
    public void transitionInto(RunState state) {
        for (OutputHandler handler : this.outputHandlers) {
            try {
                handler.transitionInto(state);
            }
            catch (Throwable e) {
                LOG.warn("Output handler {} threw", (Object)handler, (Object)e);
            }
        }
    }
}

