/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.common.base.Throwables;
import com.spotify.styx.util.Time;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedSupplier<T>
implements Supplier<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CachedSupplier.class);
    private static final long DEFAULT_TIMEOUT_MILLIS = 30000L;
    private final ThrowingSupplier<T, Exception> delegate;
    private final Time time;
    private final long timeoutMillis;
    private final AtomicReference<T> cachedValue = new AtomicReference();
    private volatile long cacheTime;

    public CachedSupplier(ThrowingSupplier<T, Exception> delegate, Time time) {
        this(delegate, time, 30000L);
    }

    public CachedSupplier(ThrowingSupplier<T, Exception> delegate, Time time, long timeoutMillis) {
        this.delegate = Objects.requireNonNull(delegate);
        this.time = Objects.requireNonNull(time);
        this.timeoutMillis = timeoutMillis;
        this.cacheTime = ((Instant)time.get()).toEpochMilli();
    }

    @Override
    public T get() {
        T value = this.cachedValue.get();
        if (value == null || this.timedOut()) {
            try {
                T newValue = this.delegate.get();
                this.cachedValue.set(newValue);
                this.cacheTime = ((Instant)this.time.get()).toEpochMilli();
                value = newValue;
            }
            catch (Throwable e) {
                if (value == null) {
                    throw Throwables.propagate((Throwable)e);
                }
                LOG.warn("Failed to update from delegate supplier, using old value");
            }
        }
        return value;
    }

    private boolean timedOut() {
        return ((Instant)this.time.get()).toEpochMilli() - this.cacheTime > this.timeoutMillis;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

