/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.spotify.styx.model.WorkflowState;
import java.time.Instant;
import java.util.Optional;

public final class WorkflowStateUtil {
    private WorkflowStateUtil() {
    }

    public static WorkflowState patchWorkflowState(Optional<WorkflowState> originalWorkflowState, WorkflowState patch) {
        return originalWorkflowState.map(o -> {
            WorkflowState.Builder builder = o.toBuilder().enabled(patch.enabled().orElse(o.enabled().orElse(false)));
            patch.dockerImage().ifPresent(dockerImage -> builder.dockerImage((String)dockerImage));
            patch.commitSha().ifPresent(commitSha -> builder.commitSha((String)commitSha));
            patch.nextNaturalTrigger().ifPresent(nextNaturalTrigger -> builder.nextNaturalTrigger((Instant)nextNaturalTrigger));
            return builder.build();
        }).orElse(patch);
    }
}

