/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.spotify.styx.api.Middlewares;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class AuthContextBuilder {
    private Optional<GoogleIdToken> user;

    public AuthContextBuilder() {
        this.user = Optional.empty();
    }

    private AuthContextBuilder(Middlewares.AuthContext v) {
        this.user = v.user();
    }

    private AuthContextBuilder(AuthContextBuilder v) {
        this.user = v.user;
    }

    public Optional<GoogleIdToken> user() {
        return this.user;
    }

    public AuthContextBuilder user(GoogleIdToken user) {
        return this.user(Optional.ofNullable(user));
    }

    public AuthContextBuilder user(Optional<? extends GoogleIdToken> user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        this.user = user;
        return this;
    }

    public Middlewares.AuthContext build() {
        return new Value(this.user);
    }

    public static AuthContextBuilder from(Middlewares.AuthContext v) {
        return new AuthContextBuilder(v);
    }

    public static AuthContextBuilder from(AuthContextBuilder v) {
        return new AuthContextBuilder(v);
    }

    private static final class Value
    implements Middlewares.AuthContext {
        private final Optional<GoogleIdToken> user;

        private Value(@AutoMatter.Field(value="user") Optional<GoogleIdToken> user) {
            if (user == null) {
                throw new NullPointerException("user");
            }
            this.user = user;
        }

        @Override
        @AutoMatter.Field
        public Optional<GoogleIdToken> user() {
            return this.user;
        }

        public AuthContextBuilder builder() {
            return new AuthContextBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Middlewares.AuthContext)) {
                return false;
            }
            Middlewares.AuthContext that = (Middlewares.AuthContext)o;
            return !(this.user != null ? !this.user.equals(that.user()) : that.user() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Middlewares.AuthContext{user=" + this.user + '}';
        }
    }
}

