/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.styx.model.WorkflowState;
import java.time.Instant;
import java.util.Optional;

final class AutoValue_WorkflowState
extends WorkflowState {
    private final Optional<Boolean> enabled;
    private final Optional<String> dockerImage;
    private final Optional<String> commitSha;
    private final Optional<Instant> nextNaturalTrigger;
    private final Optional<Instant> nextNaturalOffsetTrigger;

    private AutoValue_WorkflowState(Optional<Boolean> enabled, Optional<String> dockerImage, Optional<String> commitSha, Optional<Instant> nextNaturalTrigger, Optional<Instant> nextNaturalOffsetTrigger) {
        this.enabled = enabled;
        this.dockerImage = dockerImage;
        this.commitSha = commitSha;
        this.nextNaturalTrigger = nextNaturalTrigger;
        this.nextNaturalOffsetTrigger = nextNaturalOffsetTrigger;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty
    public Optional<String> dockerImage() {
        return this.dockerImage;
    }

    @Override
    @JsonProperty
    public Optional<String> commitSha() {
        return this.commitSha;
    }

    @Override
    @JsonProperty
    public Optional<Instant> nextNaturalTrigger() {
        return this.nextNaturalTrigger;
    }

    @Override
    @JsonProperty
    public Optional<Instant> nextNaturalOffsetTrigger() {
        return this.nextNaturalOffsetTrigger;
    }

    public String toString() {
        return "WorkflowState{enabled=" + this.enabled + ", dockerImage=" + this.dockerImage + ", commitSha=" + this.commitSha + ", nextNaturalTrigger=" + this.nextNaturalTrigger + ", nextNaturalOffsetTrigger=" + this.nextNaturalOffsetTrigger + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WorkflowState) {
            WorkflowState that = (WorkflowState)o;
            return this.enabled.equals(that.enabled()) && this.dockerImage.equals(that.dockerImage()) && this.commitSha.equals(that.commitSha()) && this.nextNaturalTrigger.equals(that.nextNaturalTrigger()) && this.nextNaturalOffsetTrigger.equals(that.nextNaturalOffsetTrigger());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.enabled.hashCode();
        h *= 1000003;
        h ^= this.dockerImage.hashCode();
        h *= 1000003;
        h ^= this.commitSha.hashCode();
        h *= 1000003;
        h ^= this.nextNaturalTrigger.hashCode();
        h *= 1000003;
        return h ^= this.nextNaturalOffsetTrigger.hashCode();
    }

    @Override
    public WorkflowState.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends WorkflowState.Builder {
        private Optional<Boolean> enabled = Optional.empty();
        private Optional<String> dockerImage = Optional.empty();
        private Optional<String> commitSha = Optional.empty();
        private Optional<Instant> nextNaturalTrigger = Optional.empty();
        private Optional<Instant> nextNaturalOffsetTrigger = Optional.empty();

        Builder() {
        }

        Builder(WorkflowState source) {
            this.enabled = source.enabled();
            this.dockerImage = source.dockerImage();
            this.commitSha = source.commitSha();
            this.nextNaturalTrigger = source.nextNaturalTrigger();
            this.nextNaturalOffsetTrigger = source.nextNaturalOffsetTrigger();
        }

        @Override
        public WorkflowState.Builder enabled(boolean enabled) {
            this.enabled = Optional.of(enabled);
            return this;
        }

        @Override
        public WorkflowState.Builder dockerImage(String dockerImage) {
            this.dockerImage = Optional.of(dockerImage);
            return this;
        }

        @Override
        public WorkflowState.Builder commitSha(String commitSha) {
            this.commitSha = Optional.of(commitSha);
            return this;
        }

        @Override
        public WorkflowState.Builder nextNaturalTrigger(Instant nextNaturalTrigger) {
            this.nextNaturalTrigger = Optional.of(nextNaturalTrigger);
            return this;
        }

        @Override
        public WorkflowState.Builder nextNaturalOffsetTrigger(Instant nextNaturalOffsetTrigger) {
            this.nextNaturalOffsetTrigger = Optional.of(nextNaturalOffsetTrigger);
            return this;
        }

        @Override
        public WorkflowState build() {
            return new AutoValue_WorkflowState(this.enabled, this.dockerImage, this.commitSha, this.nextNaturalTrigger, this.nextNaturalOffsetTrigger);
        }
    }
}

