/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.WorkflowConfiguration;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class WorkflowConfigurationBuilder {
    private String id;
    private Schedule schedule;
    private Optional<String> offset;
    private Optional<String> dockerImage;
    private Optional<List<String>> dockerArgs;
    private boolean dockerTerminationLogging;
    private Optional<WorkflowConfiguration.Secret> secret;
    private Optional<String> serviceAccount;
    private List<String> resources;

    public WorkflowConfigurationBuilder() {
        this.offset = Optional.empty();
        this.dockerImage = Optional.empty();
        this.dockerArgs = Optional.empty();
        this.secret = Optional.empty();
        this.serviceAccount = Optional.empty();
    }

    private WorkflowConfigurationBuilder(WorkflowConfiguration v) {
        this.id = v.id();
        this.schedule = v.schedule();
        this.offset = v.offset();
        this.dockerImage = v.dockerImage();
        this.dockerArgs = v.dockerArgs();
        this.dockerTerminationLogging = v.dockerTerminationLogging();
        this.secret = v.secret();
        this.serviceAccount = v.serviceAccount();
        List<String> _resources = v.resources();
        this.resources = _resources == null ? null : new ArrayList<String>(_resources);
    }

    private WorkflowConfigurationBuilder(WorkflowConfigurationBuilder v) {
        this.id = v.id;
        this.schedule = v.schedule;
        this.offset = v.offset;
        this.dockerImage = v.dockerImage;
        this.dockerArgs = v.dockerArgs;
        this.dockerTerminationLogging = v.dockerTerminationLogging;
        this.secret = v.secret;
        this.serviceAccount = v.serviceAccount;
        this.resources = v.resources == null ? null : new ArrayList<String>(v.resources);
    }

    public String id() {
        return this.id;
    }

    public WorkflowConfigurationBuilder id(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.id = id;
        return this;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public WorkflowConfigurationBuilder schedule(Schedule schedule) {
        if (schedule == null) {
            throw new NullPointerException("schedule");
        }
        this.schedule = schedule;
        return this;
    }

    public Optional<String> offset() {
        return this.offset;
    }

    public WorkflowConfigurationBuilder offset(String offset) {
        return this.offset(Optional.ofNullable(offset));
    }

    public WorkflowConfigurationBuilder offset(Optional<? extends String> offset) {
        if (offset == null) {
            throw new NullPointerException("offset");
        }
        this.offset = offset;
        return this;
    }

    public Optional<String> dockerImage() {
        return this.dockerImage;
    }

    public WorkflowConfigurationBuilder dockerImage(String dockerImage) {
        return this.dockerImage(Optional.ofNullable(dockerImage));
    }

    public WorkflowConfigurationBuilder dockerImage(Optional<? extends String> dockerImage) {
        if (dockerImage == null) {
            throw new NullPointerException("dockerImage");
        }
        this.dockerImage = dockerImage;
        return this;
    }

    public Optional<List<String>> dockerArgs() {
        return this.dockerArgs;
    }

    public WorkflowConfigurationBuilder dockerArgs(List<String> dockerArgs) {
        return this.dockerArgs(Optional.ofNullable(dockerArgs));
    }

    public WorkflowConfigurationBuilder dockerArgs(Optional<? extends List<String>> dockerArgs) {
        if (dockerArgs == null) {
            throw new NullPointerException("dockerArgs");
        }
        this.dockerArgs = dockerArgs;
        return this;
    }

    public boolean dockerTerminationLogging() {
        return this.dockerTerminationLogging;
    }

    public WorkflowConfigurationBuilder dockerTerminationLogging(boolean dockerTerminationLogging) {
        this.dockerTerminationLogging = dockerTerminationLogging;
        return this;
    }

    public Optional<WorkflowConfiguration.Secret> secret() {
        return this.secret;
    }

    public WorkflowConfigurationBuilder secret(WorkflowConfiguration.Secret secret) {
        return this.secret(Optional.ofNullable(secret));
    }

    public WorkflowConfigurationBuilder secret(Optional<? extends WorkflowConfiguration.Secret> secret) {
        if (secret == null) {
            throw new NullPointerException("secret");
        }
        this.secret = secret;
        return this;
    }

    public Optional<String> serviceAccount() {
        return this.serviceAccount;
    }

    public WorkflowConfigurationBuilder serviceAccount(String serviceAccount) {
        return this.serviceAccount(Optional.ofNullable(serviceAccount));
    }

    public WorkflowConfigurationBuilder serviceAccount(Optional<? extends String> serviceAccount) {
        if (serviceAccount == null) {
            throw new NullPointerException("serviceAccount");
        }
        this.serviceAccount = serviceAccount;
        return this;
    }

    public List<String> resources() {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        return this.resources;
    }

    public WorkflowConfigurationBuilder resources(List<? extends String> resources) {
        return this.resources((Collection<? extends String>)resources);
    }

    public WorkflowConfigurationBuilder resources(Collection<? extends String> resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        for (String string : resources) {
            if (string != null) continue;
            throw new NullPointerException("resources: null item");
        }
        this.resources = new ArrayList<String>(resources);
        return this;
    }

    public WorkflowConfigurationBuilder resources(Iterable<? extends String> resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        if (resources instanceof Collection) {
            return this.resources((Collection)resources);
        }
        return this.resources(resources.iterator());
    }

    public WorkflowConfigurationBuilder resources(Iterator<? extends String> resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        this.resources = new ArrayList<String>();
        while (resources.hasNext()) {
            String item = resources.next();
            if (item == null) {
                throw new NullPointerException("resources: null item");
            }
            this.resources.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final WorkflowConfigurationBuilder resources(String ... resources) {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        return this.resources(Arrays.asList(resources));
    }

    public WorkflowConfigurationBuilder addResource(String resource) {
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resource);
        return this;
    }

    public WorkflowConfiguration build() {
        List _resources = this.resources != null ? Collections.unmodifiableList(new ArrayList<String>(this.resources)) : Collections.emptyList();
        return new Value(this.id, this.schedule, this.offset, this.dockerImage, this.dockerArgs, this.dockerTerminationLogging, this.secret, this.serviceAccount, _resources);
    }

    public static WorkflowConfigurationBuilder from(WorkflowConfiguration v) {
        return new WorkflowConfigurationBuilder(v);
    }

    public static WorkflowConfigurationBuilder from(WorkflowConfigurationBuilder v) {
        return new WorkflowConfigurationBuilder(v);
    }

    private static final class Value
    implements WorkflowConfiguration {
        private final String id;
        private final Schedule schedule;
        private final Optional<String> offset;
        private final Optional<String> dockerImage;
        private final Optional<List<String>> dockerArgs;
        private final boolean dockerTerminationLogging;
        private final Optional<WorkflowConfiguration.Secret> secret;
        private final Optional<String> serviceAccount;
        private final List<String> resources;

        private Value(@AutoMatter.Field(value="id") String id, @AutoMatter.Field(value="schedule") Schedule schedule, @AutoMatter.Field(value="offset") Optional<String> offset, @AutoMatter.Field(value="dockerImage") Optional<String> dockerImage, @AutoMatter.Field(value="dockerArgs") Optional<List<String>> dockerArgs, @AutoMatter.Field(value="dockerTerminationLogging") boolean dockerTerminationLogging, @AutoMatter.Field(value="secret") Optional<WorkflowConfiguration.Secret> secret, @AutoMatter.Field(value="serviceAccount") Optional<String> serviceAccount, @AutoMatter.Field(value="resources") List<String> resources) {
            if (id == null) {
                throw new NullPointerException("id");
            }
            if (schedule == null) {
                throw new NullPointerException("schedule");
            }
            if (offset == null) {
                throw new NullPointerException("offset");
            }
            if (dockerImage == null) {
                throw new NullPointerException("dockerImage");
            }
            if (dockerArgs == null) {
                throw new NullPointerException("dockerArgs");
            }
            if (secret == null) {
                throw new NullPointerException("secret");
            }
            if (serviceAccount == null) {
                throw new NullPointerException("serviceAccount");
            }
            this.id = id;
            this.schedule = schedule;
            this.offset = offset;
            this.dockerImage = dockerImage;
            this.dockerArgs = dockerArgs;
            this.dockerTerminationLogging = dockerTerminationLogging;
            this.secret = secret;
            this.serviceAccount = serviceAccount;
            this.resources = resources != null ? resources : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public String id() {
            return this.id;
        }

        @Override
        @AutoMatter.Field
        public Schedule schedule() {
            return this.schedule;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> offset() {
            return this.offset;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> dockerImage() {
            return this.dockerImage;
        }

        @Override
        @AutoMatter.Field
        public Optional<List<String>> dockerArgs() {
            return this.dockerArgs;
        }

        @Override
        @AutoMatter.Field
        public boolean dockerTerminationLogging() {
            return this.dockerTerminationLogging;
        }

        @Override
        @AutoMatter.Field
        public Optional<WorkflowConfiguration.Secret> secret() {
            return this.secret;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> serviceAccount() {
            return this.serviceAccount;
        }

        @Override
        @AutoMatter.Field
        public List<String> resources() {
            return this.resources;
        }

        @Override
        public WorkflowConfigurationBuilder builder() {
            return new WorkflowConfigurationBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WorkflowConfiguration)) {
                return false;
            }
            WorkflowConfiguration that = (WorkflowConfiguration)o;
            if (this.id != null ? !this.id.equals(that.id()) : that.id() != null) {
                return false;
            }
            if (this.schedule != null ? !this.schedule.equals(that.schedule()) : that.schedule() != null) {
                return false;
            }
            if (this.offset != null ? !this.offset.equals(that.offset()) : that.offset() != null) {
                return false;
            }
            if (this.dockerImage != null ? !this.dockerImage.equals(that.dockerImage()) : that.dockerImage() != null) {
                return false;
            }
            if (this.dockerArgs != null ? !this.dockerArgs.equals(that.dockerArgs()) : that.dockerArgs() != null) {
                return false;
            }
            if (this.dockerTerminationLogging != that.dockerTerminationLogging()) {
                return false;
            }
            if (this.secret != null ? !this.secret.equals(that.secret()) : that.secret() != null) {
                return false;
            }
            if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount()) : that.serviceAccount() != null) {
                return false;
            }
            return !(this.resources != null ? !this.resources.equals(that.resources()) : that.resources() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            result = 31 * result + (this.schedule != null ? this.schedule.hashCode() : 0);
            result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
            result = 31 * result + (this.dockerImage != null ? this.dockerImage.hashCode() : 0);
            result = 31 * result + (this.dockerArgs != null ? this.dockerArgs.hashCode() : 0);
            result = 31 * result + (this.dockerTerminationLogging ? 1231 : 1237);
            result = 31 * result + (this.secret != null ? this.secret.hashCode() : 0);
            result = 31 * result + (this.serviceAccount != null ? this.serviceAccount.hashCode() : 0);
            result = 31 * result + (this.resources != null ? this.resources.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "WorkflowConfiguration{id=" + this.id + ", schedule=" + this.schedule + ", offset=" + this.offset + ", dockerImage=" + this.dockerImage + ", dockerArgs=" + this.dockerArgs + ", dockerTerminationLogging=" + this.dockerTerminationLogging + ", secret=" + this.secret + ", serviceAccount=" + this.serviceAccount + ", resources=" + this.resources + '}';
        }
    }
}

