/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.styx.model.AutoValue_WorkflowState;
import java.time.Instant;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class WorkflowState {
    @JsonProperty
    public abstract Optional<Boolean> enabled();

    @JsonProperty
    public abstract Optional<String> dockerImage();

    @JsonProperty
    public abstract Optional<String> commitSha();

    @JsonProperty
    public abstract Optional<Instant> nextNaturalTrigger();

    @JsonProperty
    public abstract Optional<Instant> nextNaturalOffsetTrigger();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_WorkflowState.Builder();
    }

    @JsonCreator
    public static WorkflowState create(@JsonProperty(value="enabled") Optional<Boolean> enabled, @JsonProperty(value="docker_image") Optional<String> dockerImage, @JsonProperty(value="commit_sha") Optional<String> commitSha, @JsonProperty(value="next_natural_trigger") Optional<Instant> nextNaturalTrigger, @JsonProperty(value="next_natural_offset_trigger") Optional<Instant> nextNaturalOffsetTrigger) {
        Builder builder = WorkflowState.builder();
        enabled.ifPresent(builder::enabled);
        dockerImage.ifPresent(builder::dockerImage);
        commitSha.ifPresent(builder::commitSha);
        nextNaturalTrigger.ifPresent(builder::nextNaturalTrigger);
        nextNaturalOffsetTrigger.ifPresent(builder::nextNaturalOffsetTrigger);
        return builder.build();
    }

    public static WorkflowState all(boolean enabled, String dockerImage, String commitSha) {
        return WorkflowState.builder().enabled(enabled).dockerImage(dockerImage).commitSha(commitSha).build();
    }

    public static WorkflowState empty() {
        return WorkflowState.builder().build();
    }

    public static WorkflowState patchDockerImage(String dockerImage) {
        return WorkflowState.builder().dockerImage(dockerImage).build();
    }

    public static WorkflowState patchEnabled(boolean enabled) {
        return WorkflowState.builder().enabled(enabled).build();
    }

    public static abstract class Builder {
        public abstract Builder enabled(boolean var1);

        public abstract Builder dockerImage(String var1);

        public abstract Builder commitSha(String var1);

        public abstract Builder nextNaturalTrigger(Instant var1);

        public abstract Builder nextNaturalOffsetTrigger(Instant var1);

        public abstract WorkflowState build();
    }
}

