/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.common.base.Throwables;
import com.spotify.styx.util.FnWithException;
import com.spotify.styx.util.RunnableWithException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retrier {
    private static final Logger LOG = LoggerFactory.getLogger(Retrier.class);
    private final int maxRetries;
    private final Duration retryDelay;
    private final String errorMessage;

    private Retrier(Builder builder) {
        this.maxRetries = builder.maxRetries;
        this.retryDelay = builder.retryDelay;
        this.errorMessage = builder.errorMessage;
    }

    public <T> T runWithRetries(FnWithException<T, ? extends Exception> operation) throws Exception {
        int retries = 0;
        while (retries < this.maxRetries) {
            try {
                return operation.apply();
            }
            catch (Exception e) {
                if (++retries == this.maxRetries) {
                    throw e;
                }
                LOG.warn(String.format("Failed to %s (attempt #%d)", this.errorMessage, retries), (Throwable)e);
                try {
                    Thread.sleep(this.retryDelay.toMillis());
                }
                catch (InterruptedException e1) {
                    throw Throwables.propagate((Throwable)e1);
                }
            }
        }
        throw new Exception("This should never happen");
    }

    public void runWithRetries(RunnableWithException<? extends Exception> operation) throws Exception {
        this.runWithRetries(() -> {
            operation.run();
            return null;
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final int DEFAULT_MAX_RETRIES = 10;
        private static final int DEFAULT_RETRY_DELAY_SECONDS = 30;
        private int maxRetries = 10;
        private Duration retryDelay = Duration.ofSeconds(30L);
        private String errorMessage = "run operation";

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder retryDelay(Duration retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Retrier build() {
            return new Retrier(this);
        }
    }
}

