/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.util.Utils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestContext;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.route.AsyncHandler;
import com.spotify.apollo.route.Middleware;
import com.spotify.apollo.route.SyncHandler;
import com.spotify.styx.api.ResponseException;
import com.spotify.styx.serialization.Json;
import io.norberg.automatter.AutoMatter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Middlewares {
    private static final Logger LOG;
    public static final String BEARER_PREFIX = "Bearer ";
    private static final Set<String> BLACKLISTED_HEADERS;
    private static final GoogleIdTokenVerifier GOOGLE_ID_TOKEN_VERIFIER;

    private Middlewares() {
    }

    public static Middleware<SyncHandler<? extends Response<?>>, AsyncHandler<Response<ByteString>>> json() {
        return innerHandler -> (AsyncHandler)Middlewares.jsonAsync().apply((Object)Middleware.syncToAsync((SyncHandler)innerHandler));
    }

    public static Middleware<AsyncHandler<? extends Response<?>>, AsyncHandler<Response<ByteString>>> jsonAsync() {
        return innerHandler -> innerHandler.map(response -> {
            if (!response.payload().isPresent()) {
                return response;
            }
            Object tPayload = response.payload().get();
            try {
                byte[] bytes = Json.OBJECT_MAPPER.writeValueAsBytes(tPayload);
                ByteString payload = ByteString.of((byte[])bytes);
                return response.withPayload((Object)payload).withHeader("Content-Type", "application/json");
            }
            catch (JsonProcessingException e) {
                return Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("Failed to serialize response " + e.getMessage()));
            }
        });
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> clientValidator(Supplier<Optional<List<String>>> supplier) {
        return innerHandler -> arg_0 -> Middlewares.lambda$null$4((Supplier)supplier, innerHandler, arg_0);
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> exceptionHandler() {
        return innerHandler -> requestContext -> {
            try {
                return innerHandler.invoke(requestContext).handle((r, t) -> {
                    if (t != null) {
                        if (t instanceof ResponseException) {
                            return ((ResponseException)t).getResponse();
                        }
                        throw new CompletionException((Throwable)t);
                    }
                    return r;
                });
            }
            catch (ResponseException e) {
                return CompletableFuture.completedFuture(e.getResponse());
            }
        };
    }

    private static GoogleIdToken verifyIdToken(String s) {
        try {
            return GOOGLE_ID_TOKEN_VERIFIER.verify(s);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> auditLogger() {
        return innerHandler -> requestContext -> {
            Request request = requestContext.request();
            if (!"GET".equals(request.method())) {
                LOG.info("[AUDIT] {} {} by {} with headers {} parameters {} and payload {}", new Object[]{request.method(), request.uri(), Middlewares.auth(requestContext).user().map(idToken -> idToken.getPayload().getEmail()).orElse("anonymous"), Middlewares.filterHeaders(request.headers()), request.parameters(), request.payload().map(ByteString::utf8).orElse("").replaceAll("\n", " ")});
            }
            return innerHandler.invoke(requestContext);
        };
    }

    private static AuthContext auth(RequestContext requestContext) {
        GoogleIdToken googleIdToken;
        Request request = requestContext.request();
        boolean hasAuthHeader = request.header("Authorization").isPresent();
        if (!hasAuthHeader) {
            return Optional::empty;
        }
        String authHeader = (String)request.header("Authorization").get();
        if (!authHeader.startsWith(BEARER_PREFIX)) {
            throw new ResponseException(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Authorization token must be of type Bearer")));
        }
        try {
            String token = authHeader.substring(BEARER_PREFIX.length());
            googleIdToken = Middlewares.verifyIdToken(token);
        }
        catch (IllegalArgumentException e) {
            throw new ResponseException(Response.forStatus((StatusType)Status.BAD_REQUEST.withReasonPhrase("Failed to parse Authorization token")), (Throwable)e);
        }
        if (googleIdToken == null) {
            throw new ResponseException(Response.forStatus((StatusType)Status.UNAUTHORIZED.withReasonPhrase("Authorization token is invalid")));
        }
        return () -> Optional.of(googleIdToken);
    }

    private static Map<String, String> filterHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().filter(entry -> !BLACKLISTED_HEADERS.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <T> Middleware<Requested<Authenticated<T>>, AsyncHandler<Response<ByteString>>> authed() {
        return ar -> (AsyncHandler)Middlewares.jsonAsync().apply(requestContext -> {
            Object payload = ((Authenticated)ar.apply(requestContext)).apply(Middlewares.auth(requestContext));
            return CompletableFuture.completedFuture(Response.forPayload(payload));
        });
    }

    public static <T> Middleware<AsyncHandler<Response<T>>, AsyncHandler<Response<T>>> authValidator() {
        return h -> rc -> {
            if (!"GET".equals(rc.request().method()) && !Middlewares.auth(rc).user().isPresent()) {
                return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.UNAUTHORIZED.withReasonPhrase("Unauthorized access")));
            }
            return h.invoke(rc);
        };
    }

    private static /* synthetic */ CompletionStage lambda$null$4(Supplier supplier, AsyncHandler innerHandler, RequestContext requestContext) {
        if (requestContext.request().header("User-Agent").map(arg_0 -> Middlewares.lambda$null$3((Supplier)supplier, arg_0)).orElse(false).booleanValue()) {
            return CompletableFuture.completedFuture(Response.forStatus((StatusType)Status.NOT_ACCEPTABLE.withReasonPhrase("blacklisted client version, please upgrade")));
        }
        return innerHandler.invoke(requestContext);
    }

    private static /* synthetic */ Boolean lambda$null$3(Supplier supplier, String header) {
        return ((List)((Optional)supplier.get()).orElse(ImmutableList.of())).contains(header);
    }

    static {
        NetHttpTransport transport;
        LOG = LoggerFactory.getLogger(Middlewares.class);
        BLACKLISTED_HEADERS = ImmutableSet.of((Object)"Authorization");
        try {
            transport = GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        GOOGLE_ID_TOKEN_VERIFIER = new GoogleIdTokenVerifier.Builder((HttpTransport)transport, Utils.getDefaultJsonFactory()).build();
    }

    static interface Requested<T>
    extends Function<RequestContext, T> {
    }

    static interface Authenticated<T>
    extends Function<AuthContext, T> {
    }

    @AutoMatter
    public static interface AuthContext {
        public Optional<GoogleIdToken> user();
    }
}

