/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.spotify.styx.api.Api;
import com.spotify.styx.model.AutoValue_Workflow;
import com.spotify.styx.model.WorkflowConfiguration;
import com.spotify.styx.model.WorkflowId;
import java.net.URI;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Workflow {
    @JsonProperty
    public abstract String componentId();

    @JsonProperty
    public abstract String workflowId();

    @JsonProperty
    public abstract Optional<URI> componentUri();

    @JsonProperty(value="__from_api")
    public abstract Optional<Api.Version> fromApi();

    @JsonProperty
    public abstract WorkflowConfiguration configuration();

    public WorkflowId id() {
        return WorkflowId.ofWorkflow(this);
    }

    @JsonCreator
    public static Workflow create(@JsonProperty(value="component_id") String componentId, @JsonProperty(value="component_uri") Optional<URI> componentUri, @JsonProperty(value="__from_api") Optional<Api.Version> fromApi, @JsonProperty(value="configuration") WorkflowConfiguration configuration) {
        return new AutoValue_Workflow(componentId, configuration.id(), componentUri, fromApi, configuration);
    }

    public static Workflow create(String componentId, URI componentUri, WorkflowConfiguration configuration) {
        return new AutoValue_Workflow(componentId, configuration.id(), Optional.of(componentUri), Optional.empty(), configuration);
    }
}

