/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.state;

import com.spotify.styx.model.Event;
import com.spotify.styx.model.EventVisitor;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.state.AutoValue_RunState;
import com.spotify.styx.state.Message;
import com.spotify.styx.state.OutputHandler;
import com.spotify.styx.state.StateData;
import com.spotify.styx.state.Trigger;
import com.spotify.styx.util.Time;
import com.spotify.styx.util.TriggerUtil;
import java.time.Instant;
import java.util.Optional;

public abstract class RunState {
    public static final int SUCCESS_EXIT_CODE = 0;
    public static final int MISSING_DEPS_EXIT_CODE = 20;
    public static final double FAILURE_COST = 1.0;
    public static final double MISSING_DEPS_COST = 0.1;
    private final EventVisitor<RunState> visitor = new TransitionVisitor();

    public abstract WorkflowInstance workflowInstance();

    public abstract State state();

    public abstract long timestamp();

    public abstract StateData data();

    abstract Time time();

    abstract OutputHandler outputHandler();

    public static RunState fresh(WorkflowInstance workflowInstance, Time time, OutputHandler outputHandler) {
        return RunState.create(workflowInstance, State.NEW, time, outputHandler);
    }

    public static RunState fresh(WorkflowInstance workflowInstance, Time time, OutputHandler ... outputHandlers) {
        return RunState.fresh(workflowInstance, time, OutputHandler.fanOutput(outputHandlers));
    }

    public static RunState fresh(WorkflowInstance workflowInstance, OutputHandler ... outputHandlers) {
        return RunState.fresh(workflowInstance, Instant::now, OutputHandler.fanOutput(outputHandlers));
    }

    public RunState transition(Event event) {
        return event.accept(this.visitor);
    }

    public RunState withHandlers(OutputHandler[] outputHandlers) {
        return new AutoValue_RunState(this.workflowInstance(), this.state(), this.timestamp(), this.data(), this.time(), OutputHandler.fanOutput(outputHandlers));
    }

    public RunState withTime(Time time) {
        return new AutoValue_RunState(this.workflowInstance(), this.state(), this.timestamp(), this.data(), time, this.outputHandler());
    }

    private RunState state(State state, StateData newStateData) {
        return new AutoValue_RunState(this.workflowInstance(), state, ((Instant)this.time().get()).toEpochMilli(), newStateData, this.time(), this.outputHandler());
    }

    private RunState state(State state) {
        return new AutoValue_RunState(this.workflowInstance(), state, ((Instant)this.time().get()).toEpochMilli(), this.data(), this.time(), this.outputHandler());
    }

    private IllegalStateException illegalTransition(String event) {
        String key = this.workflowInstance().toKey();
        return new IllegalStateException(key + " received " + event + " while in " + (Object)((Object)this.state()));
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, Time time, OutputHandler ... outputHandler) {
        return RunState.create(workflowInstance, state, StateData.zero(), time, outputHandler);
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, OutputHandler ... outputHandler) {
        return RunState.create(workflowInstance, state, StateData.zero(), outputHandler);
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, StateData stateData, Time time, OutputHandler ... outputHandler) {
        return new AutoValue_RunState(workflowInstance, state, ((Instant)time.get()).toEpochMilli(), stateData, time, OutputHandler.fanOutput(outputHandler));
    }

    public static RunState create(WorkflowInstance workflowInstance, State state, StateData stateData, OutputHandler ... outputHandler) {
        return new AutoValue_RunState(workflowInstance, state, System.currentTimeMillis(), stateData, Instant::now, OutputHandler.fanOutput(outputHandler));
    }

    private class TransitionVisitor
    implements EventVisitor<RunState> {
        private TransitionVisitor() {
        }

        @Override
        @Deprecated
        public RunState timeTrigger(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case NEW: {
                    return RunState.this.state(State.SUBMITTED, RunState.this.data().builder().trigger(Trigger.unknown("UNKNOWN")).triggerId("UNKNOWN").build());
                }
            }
            throw RunState.this.illegalTransition("timeTrigger");
        }

        @Override
        public RunState triggerExecution(WorkflowInstance workflowInstance, Trigger trigger) {
            switch (RunState.this.state()) {
                case NEW: {
                    return RunState.this.state(State.QUEUED, RunState.this.data().builder().trigger(trigger).triggerId(TriggerUtil.triggerId(trigger)).build());
                }
            }
            throw RunState.this.illegalTransition("triggerExecution");
        }

        @Override
        @Deprecated
        public RunState created(WorkflowInstance workflowInstance, String executionId, String dockerImage) {
            switch (RunState.this.state()) {
                case PREPARE: 
                case QUEUED: {
                    return RunState.this.state(State.SUBMITTED, RunState.this.data().builder().executionId(executionId).executionDescription(ExecutionDescription.forImage(dockerImage)).tries(RunState.this.data().tries() + 1).build());
                }
            }
            throw RunState.this.illegalTransition("created");
        }

        @Override
        public RunState info(WorkflowInstance workflowInstance, Message message) {
            switch (RunState.this.state()) {
                case QUEUED: {
                    return RunState.this.state(State.QUEUED, RunState.this.data().builder().addMessage(message).build());
                }
            }
            throw RunState.this.illegalTransition("info");
        }

        @Override
        public RunState dequeue(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case QUEUED: {
                    return RunState.this.state(State.PREPARE);
                }
            }
            throw RunState.this.illegalTransition("dequeue");
        }

        @Override
        public RunState submit(WorkflowInstance workflowInstance, ExecutionDescription executionDescription, String executionId) {
            switch (RunState.this.state()) {
                case PREPARE: 
                case QUEUED: {
                    return RunState.this.state(State.SUBMITTING, RunState.this.data().builder().executionDescription(executionDescription).executionId(executionId).build());
                }
            }
            throw RunState.this.illegalTransition("submit");
        }

        @Override
        public RunState submitted(WorkflowInstance workflowInstance, String executionId) {
            switch (RunState.this.state()) {
                case SUBMITTING: {
                    return RunState.this.state(State.SUBMITTED, RunState.this.data().builder().tries(RunState.this.data().tries() + 1).executionId(RunState.this.data().executionId().orElse(executionId)).build());
                }
            }
            throw RunState.this.illegalTransition("submitted");
        }

        @Override
        public RunState started(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case PREPARE: 
                case SUBMITTED: {
                    return RunState.this.state(State.RUNNING);
                }
            }
            throw RunState.this.illegalTransition("started");
        }

        @Override
        public RunState terminate(WorkflowInstance workflowInstance, Optional<Integer> exitCode) {
            switch (RunState.this.state()) {
                case RUNNING: {
                    double cost = this.exitCost(exitCode);
                    int consecutiveFailures = this.consecutiveFailures(RunState.this.data(), exitCode);
                    Message.MessageLevel level = this.messageLevel(exitCode);
                    StateData newStateData = RunState.this.data().builder().retryCost(RunState.this.data().retryCost() + cost).lastExit(exitCode).consecutiveFailures(consecutiveFailures).addMessage(Message.create(level, "Exit code: " + exitCode.map(String::valueOf).orElse("-"))).build();
                    return RunState.this.state(State.TERMINATED, newStateData);
                }
            }
            throw RunState.this.illegalTransition("terminate");
        }

        double exitCost(Optional<Integer> exitCode) {
            return exitCode.map(c -> {
                switch (c) {
                    case 0: {
                        return 0.0;
                    }
                    case 20: {
                        return 0.1;
                    }
                }
                return 1.0;
            }).orElse(1.0);
        }

        int consecutiveFailures(StateData data, Optional<Integer> exitCode) {
            return exitCode.map(c -> {
                switch (c) {
                    case 0: 
                    case 20: {
                        return 0;
                    }
                }
                return data.consecutiveFailures() + 1;
            }).orElse(data.consecutiveFailures() + 1);
        }

        Message.MessageLevel messageLevel(Optional<Integer> exitCode) {
            return exitCode.map(c -> {
                switch (c) {
                    case 0: {
                        return Message.MessageLevel.INFO;
                    }
                    case 20: {
                        return Message.MessageLevel.WARNING;
                    }
                }
                return Message.MessageLevel.ERROR;
            }).orElse(Message.MessageLevel.ERROR);
        }

        @Override
        public RunState runError(WorkflowInstance workflowInstance, String message) {
            switch (RunState.this.state()) {
                case PREPARE: 
                case QUEUED: 
                case SUBMITTING: 
                case SUBMITTED: 
                case RUNNING: {
                    StateData newStateData = RunState.this.data().builder().retryCost(RunState.this.data().retryCost() + 1.0).lastExit(Optional.empty()).consecutiveFailures(RunState.this.data().consecutiveFailures() + 1).addMessage(Message.error(message)).build();
                    return RunState.this.state(State.FAILED, newStateData);
                }
            }
            throw RunState.this.illegalTransition("runError");
        }

        @Override
        public RunState success(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case TERMINATED: {
                    return RunState.this.state(State.DONE);
                }
            }
            throw RunState.this.illegalTransition("success");
        }

        @Override
        public RunState retryAfter(WorkflowInstance workflowInstance, long delayMillis) {
            switch (RunState.this.state()) {
                case TERMINATED: 
                case FAILED: {
                    return RunState.this.state(State.QUEUED, RunState.this.data().builder().retryDelayMillis(delayMillis).build());
                }
            }
            throw RunState.this.illegalTransition("retryAfter");
        }

        @Override
        @Deprecated
        public RunState retry(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case QUEUED: 
                case TERMINATED: 
                case FAILED: {
                    return RunState.this.state(State.PREPARE);
                }
            }
            throw RunState.this.illegalTransition("retry");
        }

        @Override
        public RunState stop(WorkflowInstance workflowInstance) {
            switch (RunState.this.state()) {
                case TERMINATED: 
                case FAILED: {
                    return RunState.this.state(State.ERROR);
                }
            }
            throw RunState.this.illegalTransition("stop");
        }

        @Override
        public RunState timeout(WorkflowInstance workflowInstance) {
            return RunState.this.state(State.FAILED);
        }

        @Override
        public RunState halt(WorkflowInstance workflowInstance) {
            return RunState.this.state(State.ERROR);
        }
    }

    public static enum State {
        NEW(false),
        QUEUED(false),
        PREPARE(false),
        SUBMITTING(false),
        SUBMITTED(false),
        RUNNING(false),
        TERMINATED(false),
        FAILED(false),
        ERROR(true),
        DONE(true);

        private final boolean terminal;

        private State(boolean terminal) {
            this.terminal = terminal;
        }

        public boolean isTerminal() {
            return this.terminal;
        }
    }
}

