/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.testdata;

import com.google.common.collect.ImmutableList;
import com.spotify.styx.model.ExecutionDescription;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.model.WorkflowConfiguration;
import com.spotify.styx.model.WorkflowId;
import com.spotify.styx.model.WorkflowInstance;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class TestData {
    public static final URI WORKFLOW_URI = URI.create("http://example.com/foo/bar");
    public static final WorkflowId WORKFLOW_ID = WorkflowId.create("styx", "styx.TestEndpoint");
    public static final WorkflowId WORKFLOW_ID_2 = WorkflowId.create("ranic", "ranic");
    public static final WorkflowInstance WORKFLOW_INSTANCE = WorkflowInstance.create(WORKFLOW_ID, "2016-09-01");
    public static final WorkflowConfiguration HOURLY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").schedule(Schedule.HOURS).build();
    public static final WorkflowConfiguration DAILY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").schedule(Schedule.DAYS).build();
    public static final WorkflowConfiguration WEEKLY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").schedule(Schedule.WEEKS).build();
    public static final WorkflowConfiguration MONTHLY_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").schedule(Schedule.MONTHS).build();
    public static final WorkflowConfiguration FULL_WORKFLOW_CONFIGURATION = WorkflowConfiguration.builder().id("styx.TestEndpoint").schedule(Schedule.DAYS).dockerImage("busybox").dockerArgs((List<String>)ImmutableList.of((Object)"x", (Object)"y")).secret(WorkflowConfiguration.Secret.create("name", "/path")).build();
    public static final ExecutionDescription EXECUTION_DESCRIPTION = ExecutionDescription.create("busybox:1.1", Arrays.asList("foo", "bar"), false, Optional.of(WorkflowConfiguration.Secret.create("secret", "/dev/null")), Optional.empty(), Optional.of("00000ef508c1cb905e360590ce3e7e9193f6b370"));

    private TestData() {
    }
}

