/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.google.common.collect.Lists;
import com.spotify.styx.model.Schedule;
import com.spotify.styx.util.TimeUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParameterUtil {
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{4})(-\\d{2})?");
    private static final Pattern YEAR_MONTH_PATTERN = Pattern.compile("(\\d{4})-(\\d{2})");
    private static final int MIN_YEAR_WIDTH = 4;
    private static final int MAX_YEAR_WIDTH = 10;
    private static final DateTimeFormatter DATE_HOUR_FORMAT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendLiteral('.').appendValue(ChronoField.NANO_OF_SECOND, 1, 9, SignStyle.NORMAL).optionalEnd().optionalEnd().optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().optionalEnd().toFormatter().withResolverStyle(ResolverStyle.STRICT).withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter ISO_LOCAL_YEAR = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).toFormatter();
    private static final DateTimeFormatter ISO_LOCAL_MONTH = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter();
    private static final DateTimeFormatter ISO_LOCAL_DATE_HOUR = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).toFormatter();

    private ParameterUtil() {
    }

    public static Instant parseDate(String date) {
        return Instant.from(LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(date)).atStartOfDay(ZoneOffset.UTC));
    }

    public static Instant parseDateHour(String dateHour) {
        return Instant.from(LocalDateTime.from(ISO_LOCAL_DATE_HOUR.parse(dateHour)).atOffset(ZoneOffset.UTC));
    }

    public static String toParameter(Schedule schedule, Instant instant) {
        switch (schedule.wellKnown()) {
            case DAILY: 
            case WEEKLY: {
                return ParameterUtil.formatDate(instant);
            }
            case HOURLY: {
                return ParameterUtil.formatDateHour(instant);
            }
            case MONTHLY: {
                return ParameterUtil.formatMonth(instant);
            }
            case YEARLY: {
                return ParameterUtil.formatYear(instant);
            }
        }
        return ParameterUtil.formatDateTime(instant);
    }

    public static List<Instant> rangeOfInstants(Instant startInstant, Instant endInstant, Schedule schedule) {
        if (endInstant.isBefore(startInstant)) {
            throw new IllegalArgumentException("End time cannot be earlier the start time");
        }
        ArrayList listOfInstants = Lists.newArrayList();
        Instant instantToProcess = startInstant;
        while (instantToProcess.isBefore(endInstant)) {
            listOfInstants.add(instantToProcess);
            instantToProcess = TimeUtil.nextInstant(instantToProcess, schedule);
        }
        return listOfInstants;
    }

    public static Instant parseAlignedInstant(String dateHour, Schedule schedule) {
        Matcher matcher;
        Schedule.WellKnown wellKnown = schedule.wellKnown();
        ZonedDateTime parsed = wellKnown == Schedule.WellKnown.YEARLY && (matcher = YEAR_PATTERN.matcher(dateHour)).matches() ? LocalDate.of(Integer.parseInt(matcher.group(1)), 1, 1).atStartOfDay(ZoneOffset.UTC) : (wellKnown == Schedule.WellKnown.MONTHLY && (matcher = YEAR_MONTH_PATTERN.matcher(dateHour)).matches() ? LocalDate.of(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), 1).atStartOfDay(ZoneOffset.UTC) : ParameterUtil.tryParseDateHour(dateHour));
        Instant instant = parsed.toInstant();
        if (!TimeUtil.isAligned(instant, schedule)) {
            return TimeUtil.lastInstant(instant, schedule);
        }
        return instant;
    }

    private static ZonedDateTime tryParseDateHour(String dateTime) {
        try {
            return ZonedDateTime.parse(dateTime, DATE_HOUR_FORMAT);
        }
        catch (DateTimeParseException ignore) {
            try {
                return LocalDate.parse(dateTime, DATE_HOUR_FORMAT).atStartOfDay(ZoneOffset.UTC);
            }
            catch (DateTimeParseException e) {
                throw new IllegalArgumentException("Cannot parse time parameter " + dateTime + " - " + e.getMessage(), e);
            }
        }
    }

    private static String formatDateTime(Instant instant) {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(instant.truncatedTo(ChronoUnit.MINUTES).atOffset(ZoneOffset.UTC));
    }

    private static String formatDate(Instant instant) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(instant.atOffset(ZoneOffset.UTC));
    }

    private static String formatDateHour(Instant instant) {
        return ISO_LOCAL_DATE_HOUR.format(instant.truncatedTo(ChronoUnit.HOURS).atOffset(ZoneOffset.UTC));
    }

    private static String formatMonth(Instant instant) {
        return ISO_LOCAL_MONTH.format(instant.truncatedTo(ChronoUnit.DAYS).atOffset(ZoneOffset.UTC));
    }

    private static String formatYear(Instant instant) {
        return ISO_LOCAL_YEAR.format(instant.truncatedTo(ChronoUnit.DAYS).atOffset(ZoneOffset.UTC));
    }
}

