/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import java.time.Duration;
import java.util.Objects;
import java.util.Random;

public class RetryUtil {
    private static final Random RANDOM = new Random();
    private final Duration baseDelay;
    private final int maxExponent;

    public RetryUtil(Duration baseDelay, int maxExponent) {
        this.baseDelay = Objects.requireNonNull(baseDelay);
        this.maxExponent = Objects.requireNonNull(maxExponent);
    }

    public Duration calculateDelay(int consecutiveFailures) {
        int cappedTries = consecutiveFailures < this.maxExponent ? consecutiveFailures : this.maxExponent;
        int multiplier = Math.max(1, RANDOM.nextInt(1 << cappedTries));
        return this.baseDelay.multipliedBy(multiplier);
    }
}

