/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.styx.util;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import com.spotify.styx.model.Schedule;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class TimeUtil {
    private static final String HOURLY_CRON = "0 * * * *";
    private static final String DAILY_CRON = "0 0 * * *";
    private static final String WEEKLY_CRON = "0 0 * * MON";
    private static final String MONTHLY_CRON = "0 0 1 * *";
    private static final String YEARLY_CRON = "0 0 1 1 *";

    public static Instant lastInstant(Instant instant, Schedule schedule) {
        ZonedDateTime utcDateTime;
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        return executionTime.isMatch(utcDateTime = instant.atZone(ZoneOffset.UTC)) ? instant : executionTime.lastExecution(utcDateTime).toInstant();
    }

    public static Instant previousInstant(Instant instant, Schedule schedule) {
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ZonedDateTime utcDateTime = instant.atZone(ZoneOffset.UTC);
        return executionTime.lastExecution(utcDateTime).toInstant();
    }

    public static Instant nextInstant(Instant instant, Schedule schedule) {
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ZonedDateTime utcDateTime = instant.atZone(ZoneOffset.UTC);
        ZonedDateTime nextDateTime = executionTime.nextExecution(utcDateTime);
        return nextDateTime.toInstant();
    }

    public static boolean isAligned(Instant instant, Schedule schedule) {
        ExecutionTime executionTime = ExecutionTime.forCron((Cron)TimeUtil.cron(schedule));
        ZonedDateTime utcDateTime = instant.atZone(ZoneOffset.UTC);
        return executionTime.isMatch(utcDateTime);
    }

    public static ZonedDateTime addOffset(ZonedDateTime time, String offset) {
        String periodOffset;
        int tPos = offset.indexOf(84);
        switch (tPos) {
            case -1: {
                periodOffset = offset;
                break;
            }
            case 1: {
                periodOffset = "P0D";
                break;
            }
            default: {
                periodOffset = offset.substring(0, tPos);
            }
        }
        String durationOffset = tPos == -1 ? "PT0S" : "P" + offset.substring(tPos);
        Period dateAmount = Period.parse(periodOffset);
        Duration timeAmount = Duration.parse(durationOffset);
        return time.plus(dateAmount).plus(timeAmount);
    }

    private static Cron cron(Schedule schedule) {
        CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
        return new CronParser(cronDefinition).parse(TimeUtil.cronExpression(schedule));
    }

    private static String cronExpression(Schedule schedule) {
        switch (schedule.wellKnown()) {
            case HOURLY: {
                return HOURLY_CRON;
            }
            case DAILY: {
                return DAILY_CRON;
            }
            case WEEKLY: {
                return WEEKLY_CRON;
            }
            case MONTHLY: {
                return MONTHLY_CRON;
            }
            case YEARLY: {
                return YEARLY_CRON;
            }
        }
        return schedule.expression();
    }
}

