package com.spotify.styx.api;

import com.google.api.services.cloudresourcemanager.model.ResourceId;
import io.norberg.automatter.AutoMatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class AuthenticatorConfigurationBuilder {
  private Set<String> domainWhitelist;

  private Set<ResourceId> resourceWhitelist;

  private String service;

  public AuthenticatorConfigurationBuilder() {
  }

  private AuthenticatorConfigurationBuilder(AuthenticatorConfiguration v) {
    Set<String> _domainWhitelist = v.domainWhitelist();
    this.domainWhitelist = (_domainWhitelist == null) ? null : new HashSet<String>(_domainWhitelist);
    Set<ResourceId> _resourceWhitelist = v.resourceWhitelist();
    this.resourceWhitelist = (_resourceWhitelist == null) ? null : new HashSet<ResourceId>(_resourceWhitelist);
    this.service = v.service();
  }

  private AuthenticatorConfigurationBuilder(AuthenticatorConfigurationBuilder v) {
    this.domainWhitelist = (v.domainWhitelist == null) ? null : new HashSet<String>(v.domainWhitelist);
    this.resourceWhitelist = (v.resourceWhitelist == null) ? null : new HashSet<ResourceId>(v.resourceWhitelist);
    this.service = v.service;
  }

  public Set<String> domainWhitelist() {
    if (this.domainWhitelist == null) {
      this.domainWhitelist = new HashSet<String>();
    }
    return domainWhitelist;
  }

  public AuthenticatorConfigurationBuilder domainWhitelist(Set<? extends String> domainWhitelist) {
    return domainWhitelist((Collection<? extends String>) domainWhitelist);
  }

  public AuthenticatorConfigurationBuilder domainWhitelist(
      Collection<? extends String> domainWhitelist) {
    if (domainWhitelist == null) {
      throw new NullPointerException("domainWhitelist");
    }
    for (String item : domainWhitelist) {
      if (item == null) {
        throw new NullPointerException("domainWhitelist: null item");
      }
    }
    this.domainWhitelist = new HashSet<String>(domainWhitelist);
    return this;
  }

  public AuthenticatorConfigurationBuilder domainWhitelist(
      Iterable<? extends String> domainWhitelist) {
    if (domainWhitelist == null) {
      throw new NullPointerException("domainWhitelist");
    }
    if (domainWhitelist instanceof Collection) {
      return domainWhitelist((Collection<? extends String>) domainWhitelist);
    }
    return domainWhitelist(domainWhitelist.iterator());
  }

  public AuthenticatorConfigurationBuilder domainWhitelist(
      Iterator<? extends String> domainWhitelist) {
    if (domainWhitelist == null) {
      throw new NullPointerException("domainWhitelist");
    }
    this.domainWhitelist = new HashSet<String>();
    while (domainWhitelist.hasNext()) {
      String item = domainWhitelist.next();
      if (item == null) {
        throw new NullPointerException("domainWhitelist: null item");
      }
      this.domainWhitelist.add(item);
    }
    return this;
  }

  @SafeVarargs
  public final AuthenticatorConfigurationBuilder domainWhitelist(String... domainWhitelist) {
    if (domainWhitelist == null) {
      throw new NullPointerException("domainWhitelist");
    }
    return domainWhitelist(Arrays.asList(domainWhitelist));
  }

  public Set<ResourceId> resourceWhitelist() {
    if (this.resourceWhitelist == null) {
      this.resourceWhitelist = new HashSet<ResourceId>();
    }
    return resourceWhitelist;
  }

  public AuthenticatorConfigurationBuilder resourceWhitelist(
      Set<? extends ResourceId> resourceWhitelist) {
    return resourceWhitelist((Collection<? extends ResourceId>) resourceWhitelist);
  }

  public AuthenticatorConfigurationBuilder resourceWhitelist(
      Collection<? extends ResourceId> resourceWhitelist) {
    if (resourceWhitelist == null) {
      throw new NullPointerException("resourceWhitelist");
    }
    for (ResourceId item : resourceWhitelist) {
      if (item == null) {
        throw new NullPointerException("resourceWhitelist: null item");
      }
    }
    this.resourceWhitelist = new HashSet<ResourceId>(resourceWhitelist);
    return this;
  }

  public AuthenticatorConfigurationBuilder resourceWhitelist(
      Iterable<? extends ResourceId> resourceWhitelist) {
    if (resourceWhitelist == null) {
      throw new NullPointerException("resourceWhitelist");
    }
    if (resourceWhitelist instanceof Collection) {
      return resourceWhitelist((Collection<? extends ResourceId>) resourceWhitelist);
    }
    return resourceWhitelist(resourceWhitelist.iterator());
  }

  public AuthenticatorConfigurationBuilder resourceWhitelist(
      Iterator<? extends ResourceId> resourceWhitelist) {
    if (resourceWhitelist == null) {
      throw new NullPointerException("resourceWhitelist");
    }
    this.resourceWhitelist = new HashSet<ResourceId>();
    while (resourceWhitelist.hasNext()) {
      ResourceId item = resourceWhitelist.next();
      if (item == null) {
        throw new NullPointerException("resourceWhitelist: null item");
      }
      this.resourceWhitelist.add(item);
    }
    return this;
  }

  @SafeVarargs
  public final AuthenticatorConfigurationBuilder resourceWhitelist(
      ResourceId... resourceWhitelist) {
    if (resourceWhitelist == null) {
      throw new NullPointerException("resourceWhitelist");
    }
    return resourceWhitelist(Arrays.asList(resourceWhitelist));
  }

  public String service() {
    return service;
  }

  public AuthenticatorConfigurationBuilder service(String service) {
    if (service == null) {
      throw new NullPointerException("service");
    }
    this.service = service;
    return this;
  }

  public AuthenticatorConfiguration build() {
    Set<String> _domainWhitelist = (domainWhitelist != null) ? Collections.unmodifiableSet(new HashSet<String>(domainWhitelist)) : Collections.<String>emptySet();
    Set<ResourceId> _resourceWhitelist = (resourceWhitelist != null) ? Collections.unmodifiableSet(new HashSet<ResourceId>(resourceWhitelist)) : Collections.<ResourceId>emptySet();
    return new Value(_domainWhitelist, _resourceWhitelist, service);
  }

  public static AuthenticatorConfigurationBuilder from(AuthenticatorConfiguration v) {
    return new AuthenticatorConfigurationBuilder(v);
  }

  public static AuthenticatorConfigurationBuilder from(AuthenticatorConfigurationBuilder v) {
    return new AuthenticatorConfigurationBuilder(v);
  }

  private static final class Value implements AuthenticatorConfiguration {
    private final Set<String> domainWhitelist;

    private final Set<ResourceId> resourceWhitelist;

    private final String service;

    private Value(@AutoMatter.Field("domainWhitelist") Set<String> domainWhitelist,
        @AutoMatter.Field("resourceWhitelist") Set<ResourceId> resourceWhitelist,
        @AutoMatter.Field("service") String service) {
      if (service == null) {
        throw new NullPointerException("service");
      }
      this.domainWhitelist = (domainWhitelist != null) ? domainWhitelist : Collections.<String>emptySet();
      this.resourceWhitelist = (resourceWhitelist != null) ? resourceWhitelist : Collections.<ResourceId>emptySet();
      this.service = service;
    }

    @AutoMatter.Field
    @Override
    public Set<String> domainWhitelist() {
      return domainWhitelist;
    }

    @AutoMatter.Field
    @Override
    public Set<ResourceId> resourceWhitelist() {
      return resourceWhitelist;
    }

    @AutoMatter.Field
    @Override
    public String service() {
      return service;
    }

    public AuthenticatorConfigurationBuilder builder() {
      return new AuthenticatorConfigurationBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof AuthenticatorConfiguration)) {
        return false;
      }
      final AuthenticatorConfiguration that = (AuthenticatorConfiguration) o;
      if (domainWhitelist != null ? !domainWhitelist.equals(that.domainWhitelist()) : that.domainWhitelist() != null) {
        return false;
      }
      if (resourceWhitelist != null ? !resourceWhitelist.equals(that.resourceWhitelist()) : that.resourceWhitelist() != null) {
        return false;
      }
      if (service != null ? !service.equals(that.service()) : that.service() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.domainWhitelist != null ? this.domainWhitelist.hashCode() : 0);
      result = 31 * result + (this.resourceWhitelist != null ? this.resourceWhitelist.hashCode() : 0);
      result = 31 * result + (this.service != null ? this.service.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "AuthenticatorConfiguration{" +
      "domainWhitelist=" + domainWhitelist +
      ", resourceWhitelist=" + resourceWhitelist +
      ", service=" + service +
      '}';
    }
  }
}
