package com.spotify.styx.api;

import com.spotify.styx.model.WorkflowInstance;
import com.spotify.styx.state.StateData;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class RunStateDataBuilder {
  private WorkflowInstance workflowInstance;

  private String state;

  private StateData stateData;

  private Optional<Long> initialTimestamp;

  private Optional<Long> latestTimestamp;

  public RunStateDataBuilder() {
    this.initialTimestamp = Optional.empty();
    this.latestTimestamp = Optional.empty();
  }

  private RunStateDataBuilder(RunStateDataPayload.RunStateData v) {
    this.workflowInstance = v.workflowInstance();
    this.state = v.state();
    this.stateData = v.stateData();
    this.initialTimestamp = v.initialTimestamp();
    this.latestTimestamp = v.latestTimestamp();
  }

  private RunStateDataBuilder(RunStateDataBuilder v) {
    this.workflowInstance = v.workflowInstance;
    this.state = v.state;
    this.stateData = v.stateData;
    this.initialTimestamp = v.initialTimestamp;
    this.latestTimestamp = v.latestTimestamp;
  }

  public WorkflowInstance workflowInstance() {
    return workflowInstance;
  }

  public RunStateDataBuilder workflowInstance(WorkflowInstance workflowInstance) {
    if (workflowInstance == null) {
      throw new NullPointerException("workflowInstance");
    }
    this.workflowInstance = workflowInstance;
    return this;
  }

  public String state() {
    return state;
  }

  public RunStateDataBuilder state(String state) {
    if (state == null) {
      throw new NullPointerException("state");
    }
    this.state = state;
    return this;
  }

  public StateData stateData() {
    return stateData;
  }

  public RunStateDataBuilder stateData(StateData stateData) {
    if (stateData == null) {
      throw new NullPointerException("stateData");
    }
    this.stateData = stateData;
    return this;
  }

  public Optional<Long> initialTimestamp() {
    return initialTimestamp;
  }

  public RunStateDataBuilder initialTimestamp(Long initialTimestamp) {
    return initialTimestamp(Optional.ofNullable(initialTimestamp));
  }

  @SuppressWarnings("unchecked")
  public RunStateDataBuilder initialTimestamp(Optional<? extends Long> initialTimestamp) {
    if (initialTimestamp == null) {
      throw new NullPointerException("initialTimestamp");
    }
    this.initialTimestamp = (Optional<Long>)initialTimestamp;
    return this;
  }

  public Optional<Long> latestTimestamp() {
    return latestTimestamp;
  }

  public RunStateDataBuilder latestTimestamp(Long latestTimestamp) {
    return latestTimestamp(Optional.ofNullable(latestTimestamp));
  }

  @SuppressWarnings("unchecked")
  public RunStateDataBuilder latestTimestamp(Optional<? extends Long> latestTimestamp) {
    if (latestTimestamp == null) {
      throw new NullPointerException("latestTimestamp");
    }
    this.latestTimestamp = (Optional<Long>)latestTimestamp;
    return this;
  }

  public RunStateDataBuilder builder() {
    return new RunStateDataBuilder(this);
  }

  public RunStateDataPayload.RunStateData build() {
    return new Value(workflowInstance, state, stateData, initialTimestamp, latestTimestamp);
  }

  public static RunStateDataBuilder from(RunStateDataPayload.RunStateData v) {
    return new RunStateDataBuilder(v);
  }

  public static RunStateDataBuilder from(RunStateDataBuilder v) {
    return new RunStateDataBuilder(v);
  }

  private static final class Value implements RunStateDataPayload.RunStateData {
    private final WorkflowInstance workflowInstance;

    private final String state;

    private final StateData stateData;

    private final Optional<Long> initialTimestamp;

    private final Optional<Long> latestTimestamp;

    private Value(@AutoMatter.Field("workflowInstance") WorkflowInstance workflowInstance,
        @AutoMatter.Field("state") String state, @AutoMatter.Field("stateData") StateData stateData,
        @AutoMatter.Field("initialTimestamp") Optional<Long> initialTimestamp,
        @AutoMatter.Field("latestTimestamp") Optional<Long> latestTimestamp) {
      if (workflowInstance == null) {
        throw new NullPointerException("workflowInstance");
      }
      if (state == null) {
        throw new NullPointerException("state");
      }
      if (stateData == null) {
        throw new NullPointerException("stateData");
      }
      if (initialTimestamp == null) {
        throw new NullPointerException("initialTimestamp");
      }
      if (latestTimestamp == null) {
        throw new NullPointerException("latestTimestamp");
      }
      this.workflowInstance = workflowInstance;
      this.state = state;
      this.stateData = stateData;
      this.initialTimestamp = initialTimestamp;
      this.latestTimestamp = latestTimestamp;
    }

    @AutoMatter.Field
    @Override
    public WorkflowInstance workflowInstance() {
      return workflowInstance;
    }

    @AutoMatter.Field
    @Override
    public String state() {
      return state;
    }

    @AutoMatter.Field
    @Override
    public StateData stateData() {
      return stateData;
    }

    @AutoMatter.Field
    @Override
    public Optional<Long> initialTimestamp() {
      return initialTimestamp;
    }

    @AutoMatter.Field
    @Override
    public Optional<Long> latestTimestamp() {
      return latestTimestamp;
    }

    @Override
    public RunStateDataBuilder builder() {
      return new RunStateDataBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof RunStateDataPayload.RunStateData)) {
        return false;
      }
      final RunStateDataPayload.RunStateData that = (RunStateDataPayload.RunStateData) o;
      if (workflowInstance != null ? !workflowInstance.equals(that.workflowInstance()) : that.workflowInstance() != null) {
        return false;
      }
      if (state != null ? !state.equals(that.state()) : that.state() != null) {
        return false;
      }
      if (stateData != null ? !stateData.equals(that.stateData()) : that.stateData() != null) {
        return false;
      }
      if (initialTimestamp != null ? !initialTimestamp.equals(that.initialTimestamp()) : that.initialTimestamp() != null) {
        return false;
      }
      if (latestTimestamp != null ? !latestTimestamp.equals(that.latestTimestamp()) : that.latestTimestamp() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.workflowInstance != null ? this.workflowInstance.hashCode() : 0);
      result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
      result = 31 * result + (this.stateData != null ? this.stateData.hashCode() : 0);
      result = 31 * result + (this.initialTimestamp != null ? this.initialTimestamp.hashCode() : 0);
      result = 31 * result + (this.latestTimestamp != null ? this.latestTimestamp.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "RunStateDataPayload.RunStateData{" +
      "workflowInstance=" + workflowInstance +
      ", state=" + state +
      ", stateData=" + stateData +
      ", initialTimestamp=" + initialTimestamp +
      ", latestTimestamp=" + latestTimestamp +
      '}';
    }
  }
}
