package com.spotify.styx.model;

import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class EditableBackfillInputBuilder {
  private String id;

  private Optional<Integer> concurrency;

  private Optional<String> description;

  public EditableBackfillInputBuilder() {
    this.concurrency = Optional.empty();
    this.description = Optional.empty();
  }

  private EditableBackfillInputBuilder(EditableBackfillInput v) {
    this.id = v.id();
    this.concurrency = v.concurrency();
    this.description = v.description();
  }

  private EditableBackfillInputBuilder(EditableBackfillInputBuilder v) {
    this.id = v.id;
    this.concurrency = v.concurrency;
    this.description = v.description;
  }

  public String id() {
    return id;
  }

  public EditableBackfillInputBuilder id(String id) {
    if (id == null) {
      throw new NullPointerException("id");
    }
    this.id = id;
    return this;
  }

  public Optional<Integer> concurrency() {
    return concurrency;
  }

  public EditableBackfillInputBuilder concurrency(Integer concurrency) {
    return concurrency(Optional.ofNullable(concurrency));
  }

  @SuppressWarnings("unchecked")
  public EditableBackfillInputBuilder concurrency(Optional<? extends Integer> concurrency) {
    if (concurrency == null) {
      throw new NullPointerException("concurrency");
    }
    this.concurrency = (Optional<Integer>)concurrency;
    return this;
  }

  public Optional<String> description() {
    return description;
  }

  public EditableBackfillInputBuilder description(String description) {
    return description(Optional.ofNullable(description));
  }

  @SuppressWarnings("unchecked")
  public EditableBackfillInputBuilder description(Optional<? extends String> description) {
    if (description == null) {
      throw new NullPointerException("description");
    }
    this.description = (Optional<String>)description;
    return this;
  }

  public EditableBackfillInput build() {
    return new Value(id, concurrency, description);
  }

  public static EditableBackfillInputBuilder from(EditableBackfillInput v) {
    return new EditableBackfillInputBuilder(v);
  }

  public static EditableBackfillInputBuilder from(EditableBackfillInputBuilder v) {
    return new EditableBackfillInputBuilder(v);
  }

  private static final class Value implements EditableBackfillInput {
    private final String id;

    private final Optional<Integer> concurrency;

    private final Optional<String> description;

    private Value(@AutoMatter.Field("id") String id,
        @AutoMatter.Field("concurrency") Optional<Integer> concurrency,
        @AutoMatter.Field("description") Optional<String> description) {
      if (id == null) {
        throw new NullPointerException("id");
      }
      if (concurrency == null) {
        throw new NullPointerException("concurrency");
      }
      if (description == null) {
        throw new NullPointerException("description");
      }
      this.id = id;
      this.concurrency = concurrency;
      this.description = description;
    }

    @AutoMatter.Field
    @Override
    public String id() {
      return id;
    }

    @AutoMatter.Field
    @Override
    public Optional<Integer> concurrency() {
      return concurrency;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> description() {
      return description;
    }

    public EditableBackfillInputBuilder builder() {
      return new EditableBackfillInputBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof EditableBackfillInput)) {
        return false;
      }
      final EditableBackfillInput that = (EditableBackfillInput) o;
      if (id != null ? !id.equals(that.id()) : that.id() != null) {
        return false;
      }
      if (concurrency != null ? !concurrency.equals(that.concurrency()) : that.concurrency() != null) {
        return false;
      }
      if (description != null ? !description.equals(that.description()) : that.description() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
      result = 31 * result + (this.concurrency != null ? this.concurrency.hashCode() : 0);
      result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "EditableBackfillInput{" +
      "id=" + id +
      ", concurrency=" + concurrency +
      ", description=" + description +
      '}';
    }
  }
}
